/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

class SimpleComponentFeature
implements ComponentFeature {
    private FeatureHolder parent;
    private FeatureHolder projectedFeatures;
    private Location location;
    private String type;
    private String source;
    private Annotation annotation;
    private StrandedFeature.Strand strand;
    private Sequence componentSequence;
    private Location componentLocation;
    private int translation;

    public SimpleComponentFeature(FeatureHolder parent, ComponentFeature.Template temp) throws BioException {
        if (this.locationContent(temp.location) != this.locationContent(temp.componentLocation)) {
            throw new BioException("Component and container locations must contain an equal number of symbols.");
        }
        if (!temp.location.isContiguous() || !temp.componentLocation.isContiguous()) {
            throw new BioException("Can only include contiguous segments in an assembly [may change in future]");
        }
        this.parent = parent;
        this.location = temp.location;
        this.type = temp.type;
        this.source = temp.source;
        this.annotation = temp.annotation;
        this.strand = temp.strand;
        this.componentSequence = temp.componentSequence;
        this.componentLocation = temp.componentLocation;
        if (temp.strand == StrandedFeature.NEGATIVE) {
            this.translation = temp.location.getMax() + temp.componentLocation.getMin();
            this.projectedFeatures = new ProjectedFeatureHolder(this.componentSequence, this, this.translation, true);
        } else if (temp.strand == StrandedFeature.POSITIVE) {
            this.translation = temp.location.getMin() - temp.componentLocation.getMin();
            this.projectedFeatures = new ProjectedFeatureHolder(this.componentSequence, this, this.translation, false);
        } else {
            throw new BioException("Strand must be specified when creating a ComponentFeature");
        }
    }

    public Feature.Template makeTemplate() {
        ComponentFeature.Template cft = new ComponentFeature.Template();
        cft.location = this.getLocation();
        cft.type = this.getType();
        cft.source = this.getSource();
        cft.annotation = this.getAnnotation();
        cft.strand = this.getStrand();
        cft.componentSequence = this.getComponentSequence();
        cft.componentLocation = this.getComponentLocation();
        return cft;
    }

    private int locationContent(Location l) {
        if (l.isContiguous()) {
            return l.getMax() - l.getMin() + 1;
        }
        int content = 0;
        Iterator i = l.blockIterator();
        while (i.hasNext()) {
            Location sl = (Location)i.next();
            content += sl.getMax() - sl.getMin() + 1;
        }
        return content;
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public Location getLocation() {
        return this.location;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    public Sequence getSequence() {
        FeatureHolder fh = this.parent;
        while (fh instanceof Feature) {
            fh = ((Feature)fh).getParent();
        }
        return (Sequence)fh;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public SymbolList getSymbols() {
        SymbolList syms = this.componentLocation.symbols(this.componentSequence);
        if (this.strand == StrandedFeature.NEGATIVE) {
            try {
                syms = DNATools.reverseComplement(syms);
            }
            catch (IllegalAlphabetException ex) {
                throw new BioError(ex);
            }
        }
        return syms;
    }

    public Sequence getComponentSequence() {
        return this.componentSequence;
    }

    public Location getComponentLocation() {
        return this.componentLocation;
    }

    protected FeatureHolder getProjectedFeatures() {
        return this.projectedFeatures;
    }

    public int countFeatures() {
        return this.componentSequence.countFeatures();
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public boolean containsFeature(Feature f) {
        return this.getProjectedFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template temp) throws BioException {
        throw new BioException("Can't create features in a ComponentFeature (yet?)");
    }

    public void removeFeature(Feature f) {
        throw new UnsupportedOperationException("Can't remove features from a ComponentFeature.");
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }
}

