/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.Index;
import org.biojava.bio.seq.db.IndexStore;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.db.SimpleIndex;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeVetoException;

public final class IndexedSequenceDB
extends AbstractSequenceDB
implements SequenceDB,
Serializable {
    private final IDMaker idMaker;
    private final IndexStore indexStore;

    public IndexedSequenceDB(IDMaker idMaker, IndexStore indexStore) {
        this.idMaker = idMaker;
        this.indexStore = indexStore;
    }

    public IndexedSequenceDB(IndexStore indexStore) {
        this(IDMaker.byName, indexStore);
    }

    public IndexStore getIndexStore() {
        return this.indexStore;
    }

    public void addFile(File seqFile) throws IllegalIDException, BioException, ChangeVetoException {
        boolean completed = false;
        try {
            try {
                seqFile = seqFile.getAbsoluteFile();
                CountedBufferedReader bReader = new CountedBufferedReader(new FileReader(seqFile));
                SequenceFormat format = this.indexStore.getFormat();
                SymbolParser symParser = this.indexStore.getSymbolParser();
                SequenceBuilderFactory sbFact = this.indexStore.getSBFactory();
                long pos = bReader.getFilePointer();
                boolean hasNextSequence = true;
                while (hasNextSequence) {
                    ElideSymbolsSequenceBuilder sb = new ElideSymbolsSequenceBuilder(sbFact.makeSequenceBuilder());
                    hasNextSequence = format.readSequence(bReader, symParser, sb);
                    Sequence seq = sb.makeSequence();
                    String id = this.idMaker.calcID(seq);
                    this.indexStore.store(new SimpleIndex(seqFile, pos, id));
                    pos = bReader.getFilePointer();
                }
                if (this.changeSupport == null) {
                    this.indexStore.commit();
                } else {
                    ChangeEvent ce = new ChangeEvent(this, SequenceDBLite.SEQUENCES);
                    this.changeSupport.firePreChangeEvent(ce);
                    this.indexStore.commit();
                    this.changeSupport.firePostChangeEvent(ce);
                }
                completed = true;
            }
            catch (IOException ioe) {
                throw new BioException(ioe, "Failed to read sequence file");
            }
            Object var14_13 = null;
            if (!completed) {
                this.indexStore.rollback();
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (!completed) {
                this.indexStore.rollback();
            }
            throw throwable;
        }
    }

    public String getName() {
        return this.indexStore.getName();
    }

    public Sequence getSequence(String id) throws IllegalIDException, BioException {
        try {
            Index indx = this.indexStore.fetch(id);
            FileReader fr = new FileReader(indx.getFile());
            long toSkip = indx.getStart();
            while (toSkip > 0L) {
                long skipped = fr.skip(toSkip);
                if (skipped < 0L) {
                    throw new IOException("Reached end of file");
                }
                toSkip -= skipped;
            }
            BufferedReader br = new BufferedReader(fr);
            SequenceBuilder sb = this.indexStore.getSBFactory().makeSequenceBuilder();
            this.indexStore.getFormat().readSequence(br, this.indexStore.getSymbolParser(), sb);
            Sequence seq = sb.makeSequence();
            br.close();
            return seq;
        }
        catch (IOException ioe) {
            throw new BioException(ioe, "Couldn't grab region of file");
        }
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator idI;
            {
                this.idI = IndexedSequenceDB.this.indexStore.getIDs().iterator();
            }

            public boolean hasNext() {
                return this.idI.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return IndexedSequenceDB.this.getSequence((String)this.idI.next());
            }
        };
    }

    public Set ids() {
        return this.indexStore.getIDs();
    }

    private static class CountedBufferedReader
    extends BufferedReader {
        private static final int DEFAULT_BUFFER_SIZE = 16384;
        private long position;
        private Reader stream;
        private char[] buffer;
        private int buffPos;
        private int buffFill;
        private boolean reachedEOF = false;
        private int mark = -1;
        private int markLimit = -1;

        public long getFilePointer() {
            return this.position;
        }

        public CountedBufferedReader(Reader stream) {
            super(new Reader(){

                public void close() {
                }

                public int read(char[] cbuf, int off, int len) {
                    return 0;
                }
            });
            this.stream = stream;
            this.buffer = new char[16384];
            this.position = 0L;
            this.buffPos = 0;
            this.buffFill = 0;
        }

        public void close() throws IOException {
            this.stream.close();
            this.stream = null;
        }

        public int read() throws IOException {
            if (this.buffPos >= this.buffFill) {
                this.fillBuffer();
            }
            if (this.reachedEOF) {
                return -1;
            }
            ++this.position;
            return this.buffer[this.buffPos++];
        }

        private int peek() throws IOException {
            if (this.buffPos >= this.buffFill) {
                this.fillBuffer();
            }
            if (this.reachedEOF) {
                return -1;
            }
            return this.buffer[this.buffPos];
        }

        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.buffPos >= this.buffFill) {
                this.fillBuffer();
            }
            if (this.reachedEOF) {
                return -1;
            }
            int toReturn = Math.min(len, this.buffFill - this.buffPos);
            System.arraycopy(this.buffer, this.buffPos, cbuf, off, toReturn);
            this.buffPos += toReturn;
            this.position += (long)toReturn;
            return toReturn;
        }

        public boolean ready() throws IOException {
            if (this.buffPos < this.buffFill) {
                return true;
            }
            return this.stream.ready();
        }

        public long skip(long n) throws IOException {
            int skipInBuffer = n < (long)this.buffer.length ? Math.min((int)n, this.buffFill - this.buffPos) : this.buffFill - this.buffPos;
            this.position += (long)skipInBuffer;
            this.buffPos += skipInBuffer;
            if (n > (long)skipInBuffer) {
                long skippedInStream;
                if (this.mark >= 0) {
                    char[] dummy = new char[(int)(n - (long)skipInBuffer)];
                    skippedInStream = this.read(dummy);
                } else {
                    skippedInStream = this.stream.skip(n - (long)skipInBuffer);
                }
                this.position += skippedInStream;
                return skippedInStream + (long)skipInBuffer;
            }
            return skipInBuffer;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int limit) throws IOException {
            if (limit + 1 > this.buffer.length) {
                char[] newBuffer = new char[limit + 1];
                System.arraycopy(this.buffer, this.buffPos, newBuffer, 0, this.buffFill - this.buffPos);
                this.buffer = newBuffer;
                this.buffFill -= this.buffPos;
                this.buffPos = 0;
            } else if (this.buffPos + limit > this.buffer.length) {
                System.arraycopy(this.buffer, this.buffPos, this.buffer, 0, this.buffFill - this.buffPos);
                this.buffFill -= this.buffPos;
                this.buffPos = 0;
            }
            this.mark = this.buffPos;
            this.markLimit = limit;
        }

        public void reset() throws IOException {
            if (this.mark < 0) {
                throw new IOException("The mark is not currently in scope");
            }
            this.position = this.position - (long)this.buffPos + (long)this.mark;
            this.buffPos = this.mark;
        }

        public String readLine() throws IOException {
            StringBuffer sb = new StringBuffer(100);
            int c = this.read();
            while (c >= 0 && c != 10 && c != 13) {
                sb.append((char)c);
                c = this.read();
            }
            if (c == 13 && (c = this.peek()) == 10) {
                this.read();
            }
            String retVal = sb.toString();
            return retVal;
        }

        private void fillBuffer() throws IOException {
            if (this.mark < 0) {
                this.buffFill = this.stream.read(this.buffer);
                if (this.buffFill == -1) {
                    this.buffFill = 0;
                    this.reachedEOF = true;
                }
                this.buffPos = 0;
            } else {
                if (this.buffPos >= this.markLimit + this.mark) {
                    this.mark = -1;
                    this.markLimit = -1;
                    this.fillBuffer();
                    return;
                }
                System.arraycopy(this.buffer, this.mark, this.buffer, 0, this.buffFill - this.mark);
                this.buffFill -= this.mark;
                this.mark = 0;
                this.buffPos = this.buffFill;
                int newChars = this.stream.read(this.buffer, this.buffFill, this.buffer.length - this.buffFill);
                if (newChars == -1) {
                    this.reachedEOF = true;
                } else {
                    this.buffFill += newChars;
                }
            }
        }
    }

    private static class ElideSymbolsSequenceBuilder
    extends SequenceBuilderFilter {
        public ElideSymbolsSequenceBuilder(SequenceBuilder delegate) {
            super(delegate);
        }

        public void addSymbols(Alphabet alpha, Symbol[] syms, int start, int length) {
        }
    }
}

