/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.emblcd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.biojava.bio.seq.db.emblcd.RecordParser;

public abstract class EmblCDROMRandomAccess {
    private File indexFile;
    protected RandomAccessFile raIndexFile;
    private int headerLength;
    private int recordLength;
    private long recordCount;
    private long lastRecord;
    protected RecordParser recParser;
    protected byte[] recBytes;

    public EmblCDROMRandomAccess(File indexFile, int headerLength, int recordLength, long recordCount) throws FileNotFoundException {
        this.indexFile = indexFile;
        this.raIndexFile = new RandomAccessFile(indexFile, "r");
        this.headerLength = headerLength;
        this.recordLength = recordLength;
        this.recordCount = recordCount;
        this.recBytes = new byte[recordLength];
        this.recParser = new RecordParser();
    }

    public File getFile() {
        return this.indexFile;
    }

    public Object[] findRecord(String identifier) throws IOException {
        long startRecord = 0L;
        long endRecord = this.recordCount - 1L;
        while (startRecord <= endRecord) {
            long midPoint = (startRecord + endRecord) / 2L;
            this.raIndexFile.seek((long)this.headerLength + midPoint * (long)this.recordLength);
            Object[] record = this.readRecord();
            String recordKey = this.getRecordKey(record);
            if (recordKey.equals(identifier)) {
                return record;
            }
            if (recordKey.compareTo(identifier) < 0) {
                startRecord = midPoint + 1L;
                continue;
            }
            endRecord = midPoint - 1L;
        }
        return new Object[0];
    }

    public void close() throws IOException {
        this.raIndexFile.close();
    }

    protected abstract Object[] readRecord() throws IOException;

    protected abstract String getRecordKey(Object[] var1);
}

