/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;

public class ProjectedFeatureWrapper
implements Feature {
    private transient ChangeSupport changeSupport;
    private final Feature feature;
    private final ProjectedFeatureHolder holder;
    private final Location newLocation;
    private FeatureHolder projectedFeatures;

    public ProjectedFeatureWrapper(Feature f, ProjectedFeatureHolder holder) {
        this.feature = f;
        this.holder = holder;
        this.newLocation = holder.getProjectedLocation(f.getLocation());
    }

    protected ChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    protected void instantiateChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public Feature getViewedFeature() {
        return this.feature;
    }

    public Feature.Template makeTemplate() {
        return this.getFeature().makeTemplate();
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Location getLocation() {
        return this.newLocation;
    }

    public FeatureHolder getParent() {
        return this.holder.getParent();
    }

    public Sequence getSequence() {
        FeatureHolder fh = this.getParent();
        while (fh instanceof Feature) {
            fh = ((Feature)fh).getParent();
        }
        return (Sequence)fh;
    }

    public String getType() {
        return this.feature.getType();
    }

    public String getSource() {
        return this.feature.getSource();
    }

    public Annotation getAnnotation() {
        return this.feature.getAnnotation();
    }

    public SymbolList getSymbols() {
        return this.feature.getSymbols();
    }

    public int countFeatures() {
        return this.feature.countFeatures();
    }

    public boolean containsFeature(Feature f) {
        if (this.countFeatures() > 0) {
            return this.getProjectedFeatures().containsFeature(f);
        }
        return false;
    }

    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            this.projectedFeatures = new ProjectedFeatureHolder(this.feature, this, this.holder.getTranslation(), this.holder.isOppositeStrand());
        }
        return this.projectedFeatures;
    }

    protected ProjectedFeatureHolder getProjectingFeatureHolder() {
        return this.holder;
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        FeatureFilter.ContainedByLocation membershipFilter = new FeatureFilter.ContainedByLocation(this.newLocation);
        if (FilterUtils.areDisjoint(ff, membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template temp) throws BioException {
        throw new BioException("Can't create subfeatures of projected features");
    }

    public void removeFeature(Feature f) {
        throw new UnsupportedOperationException("Projected features don't have children (yet).");
    }

    public void addChangeListener(ChangeListener cl) {
        this.instantiateChangeSupport();
        this.getChangeSupport().addChangeListener(cl);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.instantiateChangeSupport();
        this.getChangeSupport().addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        ChangeSupport cs = this.getChangeSupport();
        if (cs != null) {
            cs.removeChangeListener(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        ChangeSupport cs = this.getChangeSupport();
        if (cs != null) {
            cs.removeChangeListener(cl, ct);
        }
    }
}

