/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleAssembly;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.genomic.Exon;
import org.biojava.bio.seq.genomic.SpliceVariant;
import org.biojava.bio.seq.impl.SimpleRNAFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class SimpleSpliceVariant
extends SimpleRNAFeature
implements SpliceVariant {
    static /* synthetic */ Class class$org$biojava$bio$seq$genomic$Exon;

    public Sequence getRNA() {
        if (this.rna == null) {
            FeatureHolder fh = this.filter(new FeatureFilter.ByClass(class$org$biojava$bio$seq$genomic$Exon == null ? (class$org$biojava$bio$seq$genomic$Exon = SimpleSpliceVariant.class$("org.biojava.bio.seq.genomic.Exon")) : class$org$biojava$bio$seq$genomic$Exon), false);
            Exon[] exons = new Exon[fh.countFeatures()];
            int i = 0;
            Iterator fi = fh.features();
            while (fi.hasNext()) {
                exons[i++] = (Exon)fi.next();
            }
            Arrays.sort(exons, new Comparator(){

                public int compare(Object a, Object b) {
                    Location la = (Location)a;
                    Location lb = (Location)b;
                    return la.getMin() - lb.getMin();
                }

                public boolean equals(Object o) {
                    return o == this;
                }
            });
            String name = this.getType() + "/" + this.getLocation();
            String uri = this.getSequence().getURN() + "/" + name;
            SimpleAssembly sa = new SimpleAssembly(name, uri);
            ComponentFeature.Template cft = new ComponentFeature.Template();
            cft.annotation = Annotation.EMPTY_ANNOTATION;
            cft.strand = StrandedFeature.POSITIVE;
            int last = 0;
            i = 0;
            while (i < exons.length) {
                Sequence rna = exons[i].getRNA();
                int length = rna.length();
                cft.componentSequence = rna;
                cft.componentLocation = new RangeLocation(1, length);
                cft.location = new RangeLocation(last + 1, last + length);
                last += length;
                try {
                    sa.createFeature(cft);
                }
                catch (BioException be) {
                    throw new BioError(be, "Assertion Failure: Could not splice exons together");
                }
                catch (ChangeVetoException cve) {
                    throw new BioError(cve, "Assertion Failure: Spliced exons could not be modified");
                }
                ++i;
            }
            this.rna = sa;
        }
        return this.rna;
    }

    public SimpleSpliceVariant(Sequence sourceSeq, FeatureHolder parent, SpliceVariant.Template template) throws IllegalAlphabetException {
        super(sourceSeq, parent, template);
    }

    public Feature.Template makeTemplate() {
        SpliceVariant.Template svt = new SpliceVariant.Template();
        this.fillTemplate(svt);
        return svt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

