/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.FuzzyPointLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class AbstractGenEmblFileFormer {
    private static final String FEATURE_DATA_FILE = "org/biojava/bio/seq/io/FeatureQualifier.xml";
    private static final Map FEATURE_DATA = new HashMap();
    private static final Map QUALIFIER_DATA = new HashMap();
    private static final int FIRST = 0;
    private static final int OVERWIDE = 1;
    private static final int NOFIT = 2;
    private static final int FIT = 3;
    private static final int RANGE = 0;
    private static final int POINT = 1;
    private static final int FUZZY_RANGE = 2;
    private static final int FUZZY_POINT = 3;
    private static final int BETWEEN_LOCATION = 4;
    private StringBuffer ub = new StringBuffer();
    static /* synthetic */ Class class$org$biojava$bio$symbol$PointLocation;
    static /* synthetic */ Class class$org$biojava$bio$symbol$FuzzyLocation;
    static /* synthetic */ Class class$org$biojava$bio$symbol$FuzzyPointLocation;
    static /* synthetic */ Class class$org$biojava$bio$symbol$BetweenLocation;
    static /* synthetic */ Class class$org$biojava$bio$seq$io$EmblFileFormer;

    AbstractGenEmblFileFormer() {
    }

    StringBuffer formatQualifierBlock(StringBuffer sb, String text, String leader, int wrapWidth) {
        String nl = System.getProperty("line.separator");
        int tokenType = 0;
        int position = leader.length();
        sb.append(leader);
        StringTokenizer t = new StringTokenizer(text);
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            String separator = "";
            if (tokenType != 0) {
                separator = " ";
                tokenType = s.length() + 1 > wrapWidth ? 1 : (position + s.length() + 1 > wrapWidth ? 2 : 3);
            }
            switch (tokenType) {
                case 0: {
                    if (position + s.length() <= wrapWidth) {
                        sb.append(s);
                        position += s.length();
                        tokenType = 3;
                        break;
                    }
                    separator = " ";
                }
                case 1: {
                    int i = 0;
                    while (i < s.length()) {
                        if (position == wrapWidth) {
                            sb.append(nl + leader);
                            position = leader.length();
                        }
                        sb.append(s.charAt(i));
                        ++position;
                        ++i;
                    }
                    position = s.length() % wrapWidth;
                    break;
                }
                case 2: {
                    sb.append(nl + leader + s);
                    position = s.length() + leader.length();
                    break;
                }
                case 3: {
                    sb.append(separator + s);
                    position += s.length() + 1;
                    break;
                }
            }
        }
        return sb;
    }

    StringBuffer formatQualifier(StringBuffer sb, Object key, Object value) {
        sb.append("/" + key);
        String form = "quoted";
        if (QUALIFIER_DATA.containsKey(key)) {
            form = (String)((Map)QUALIFIER_DATA.get(key)).get("form");
        }
        if (form.equals("quoted")) {
            sb.append("=\"" + value + "\"");
        } else if (form.equals("bare")) {
            sb.append("=" + value);
        } else if (form.equals("paren")) {
            sb.append("(" + value + ")");
        } else if (!form.equals("empty")) {
            System.err.println("Unrecognised qualifier format: " + form);
            sb.append("=" + value);
        }
        return sb;
    }

    StringBuffer formatTokenBlock(StringBuffer sb, Symbol[] syms, int blockSize) {
        int i = 0;
        while (i < syms.length) {
            sb.append(syms[i].getToken());
            if (i > 0 && (i + 1) % blockSize == 0) {
                sb.append(' ');
            }
            ++i;
        }
        return sb;
    }

    public String formatLocation(Location loc, StrandedFeature.Strand strand) {
        StringBuffer sb = this.formatLocationBlock(new StringBuffer(), loc, strand.getValue(), "", Integer.MAX_VALUE);
        return sb.toString();
    }

    public StringBuffer formatLocation(StringBuffer sb, Location loc, StrandedFeature.Strand strand) {
        return this.formatLocationBlock(sb, loc, strand.getValue(), "", Integer.MAX_VALUE);
    }

    StringBuffer formatLocationBlock(StringBuffer sb, Location loc, int strand, String leader, int wrapWidth) {
        String nl = System.getProperty("line.separator");
        int position = leader.length();
        boolean join = false;
        boolean complement = false;
        ArrayList locs = new ArrayList();
        Iterator li = loc.blockIterator();
        while (li.hasNext()) {
            locs.add(li.next());
        }
        Collections.sort(locs, Location.naturalOrder);
        if (loc instanceof CompoundLocation) {
            join = true;
            sb.append("join(");
            position += 5;
        }
        if (strand == -1) {
            Collections.reverse(locs);
            complement = true;
        }
        int locType = 0;
        int diff = 0;
        Iterator li2 = locs.iterator();
        while (li2.hasNext()) {
            int post;
            Location thisLoc = (Location)li2.next();
            int pre = sb.length();
            locType = (class$org$biojava$bio$symbol$PointLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.PointLocation") : class$org$biojava$bio$symbol$PointLocation).isInstance(thisLoc) ? 1 : ((class$org$biojava$bio$symbol$FuzzyLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.FuzzyLocation") : class$org$biojava$bio$symbol$FuzzyLocation).isInstance(thisLoc) ? 2 : ((class$org$biojava$bio$symbol$FuzzyPointLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.FuzzyPointLocation") : class$org$biojava$bio$symbol$FuzzyPointLocation).isInstance(thisLoc) ? 3 : ((class$org$biojava$bio$symbol$BetweenLocation == null ? AbstractGenEmblFileFormer.class$("org.biojava.bio.symbol.BetweenLocation") : class$org$biojava$bio$symbol$BetweenLocation).isInstance(thisLoc) ? 4 : 0)));
            this.ub.setLength(0);
            switch (locType) {
                case 1: {
                    PointLocation pl = (PointLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatPoint(this.ub, pl).toString()) : this.formatPoint(this.ub, pl).toString());
                    break;
                }
                case 2: {
                    FuzzyLocation fl = (FuzzyLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatFuzzyRange(this.ub, fl).toString()) : this.formatFuzzyRange(this.ub, fl).toString());
                    break;
                }
                case 3: {
                    FuzzyPointLocation fpl = (FuzzyPointLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatFuzzyPoint(this.ub, fpl).toString()) : this.formatFuzzyPoint(this.ub, fpl).toString());
                    break;
                }
                case 0: {
                    RangeLocation rl = (RangeLocation)thisLoc;
                    sb.append(complement ? this.toComplement(this.formatRange(this.ub, rl).toString()) : this.formatRange(this.ub, rl).toString());
                    break;
                }
                case 4: {
                    BetweenLocation tempLocation = (BetweenLocation)thisLoc;
                    String formattedLocation = this.formatBetween(this.ub, tempLocation).toString();
                    if (complement) {
                        formattedLocation = this.toComplement(formattedLocation);
                    }
                    sb.append(formattedLocation);
                    break;
                }
            }
            if (locs.indexOf(thisLoc) + 1 < locs.size()) {
                sb.append(",");
            }
            if (position + (diff = (post = sb.length()) - pre) > wrapWidth) {
                sb.insert(sb.length() - diff, nl + leader);
                position = leader.length() + diff;
                continue;
            }
            position += diff;
        }
        if (join) {
            sb.append(")");
            if (position + 1 > wrapWidth) {
                sb.insert(sb.length() - diff, nl + leader);
                ++position;
                ++diff;
            }
        }
        return sb;
    }

    private StringBuffer formatFuzzyRange(StringBuffer sb, FuzzyLocation fl) {
        if (!fl.hasBoundedMin()) {
            sb.append("<");
            sb.append(fl.getMin());
        } else if (fl.getOuterMin() != fl.getInnerMin()) {
            sb.append("(" + fl.getOuterMin());
            sb.append(".");
            sb.append(fl.getInnerMin() + ")");
        } else {
            sb.append(fl.getMin());
        }
        sb.append("..");
        if (!fl.hasBoundedMax()) {
            sb.append(">");
            sb.append(fl.getMax());
        } else if (fl.getInnerMax() != fl.getOuterMax()) {
            sb.append("(" + fl.getInnerMax());
            sb.append(".");
            sb.append(fl.getOuterMax() + ")");
        } else {
            sb.append(fl.getMax());
        }
        return sb;
    }

    private StringBuffer formatFuzzyPoint(StringBuffer sb, FuzzyPointLocation fpl) {
        if (!fpl.hasBoundedMin()) {
            sb.append("<");
            sb.append(fpl.getMax());
        } else if (!fpl.hasBoundedMax()) {
            sb.append(">");
            sb.append(fpl.getMin());
        } else {
            sb.append("(" + fpl.getMin());
            sb.append(".");
            sb.append(fpl.getMax() + ")");
        }
        return sb;
    }

    private StringBuffer formatRange(StringBuffer sb, RangeLocation rl) {
        sb.append(rl.getMin());
        sb.append("..");
        sb.append(rl.getMax());
        return sb;
    }

    private StringBuffer formatPoint(StringBuffer sb, PointLocation pl) {
        sb.append(Integer.toString(pl.getMin()));
        return sb;
    }

    private StringBuffer formatBetween(StringBuffer sb, BetweenLocation theLocation) {
        sb.append(theLocation.getMin());
        sb.append('^');
        sb.append(theLocation.getMax());
        return sb;
    }

    private String toComplement(String value) {
        return "complement(" + value + ")";
    }

    static void loadFeatureData(String featureDataFile, Map featureData, Map qualifierData) {
        try {
            InputStream featureDataStream = (class$org$biojava$bio$seq$io$EmblFileFormer == null ? (class$org$biojava$bio$seq$io$EmblFileFormer = AbstractGenEmblFileFormer.class$("org.biojava.bio.seq.io.EmblFileFormer")) : class$org$biojava$bio$seq$io$EmblFileFormer).getClassLoader().getResourceAsStream(featureDataFile);
            if (featureDataStream == null) {
                throw new BioError("Failed to find resource: " + featureDataFile);
            }
            InputSource is = new InputSource(featureDataStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(is);
            NodeList featureNodes = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < featureNodes.getLength()) {
                Node featureNode = featureNodes.item(i);
                if (featureNode instanceof Element) {
                    Element feature = (Element)featureNode;
                    String fNodeName = feature.getNodeName();
                    if (fNodeName.equals("feature")) {
                        String featureKey = feature.getAttribute("key");
                        NodeList qualifierNodes = feature.getChildNodes();
                        int j = 0;
                        while (j < qualifierNodes.getLength()) {
                            Element qualifier;
                            String qNodeName;
                            Node qualifierNode = qualifierNodes.item(j);
                            if (qualifierNode instanceof Element && (qNodeName = (qualifier = (Element)qualifierNode).getNodeName()).equals("qualifier")) {
                                HashMap<String, Object> qData = new HashMap<String, Object>();
                                qData.put("form", qualifier.getAttribute("form"));
                                qData.put("mandatory", new Boolean(qualifier.getAttribute("mandatory")));
                                qualifierData.put(qualifier.getAttribute("name"), qData);
                            }
                            ++j;
                        }
                        featureData.put(featureKey, qualifierData.keySet());
                    }
                    featureDataStream.close();
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (BioError be) {
            be.printStackTrace();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AbstractGenEmblFileFormer.loadFeatureData(FEATURE_DATA_FILE, FEATURE_DATA, QUALIFIER_DATA);
    }
}

