/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class NameParser
implements SymbolParser,
Serializable {
    private FiniteAlphabet alphabet;
    private Map nameToSymbol = new HashMap();

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SymbolList parse(String seq) throws IllegalSymbolException {
        SimpleSymbolList rList = new SimpleSymbolList(this.getAlphabet());
        String[] names = this.nameToSymbol.keySet().toArray(new String[0]);
        while (seq.length() > 0) {
            int chosen = -1;
            int n = 0;
            while (chosen != -1 && n < names.length) {
                if (seq.startsWith(names[n])) {
                    chosen = n;
                    break;
                }
                ++n;
            }
            if (chosen == -1) {
                if (seq.length() > 10) {
                    seq = seq.substring(0, 10);
                }
                throw new IllegalSymbolException("Unable to find symbol name matching from " + seq);
            }
            rList.addSymbol(this.parseToken(names[chosen]));
            seq = seq.substring(names[chosen].length());
        }
        return rList;
    }

    public Symbol parseToken(String token) throws IllegalSymbolException {
        Symbol sym = (Symbol)this.nameToSymbol.get(token.toLowerCase());
        if (sym == null) {
            throw new IllegalSymbolException("No symbol for token '" + token + "' found in name parser for " + this.getAlphabet().getName());
        }
        return sym;
    }

    public NameParser(FiniteAlphabet alpha) {
        this.alphabet = alpha;
        Iterator i = alpha.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            this.nameToSymbol.put(sym.getName().toLowerCase(), sym);
        }
    }

    public NameParser(Map nameToSymbol) {
        this.nameToSymbol = nameToSymbol;
    }

    public StreamParser parseStream(SeqIOListener l) {
        throw new BioError("[FIXME] not implemented");
    }

    private class NameStreamParser
    implements StreamParser {
        SeqIOListener listener;
        StringBuffer sb = new StringBuffer();

        NameStreamParser(SeqIOListener l) {
            this.listener = l;
        }

        public void characters(char[] data, int start, int len) {
            this.sb.append(data, start, len);
        }

        public void close() throws IllegalSymbolException {
            SymbolList sl = NameParser.this.parse(this.sb.toString());
            this.sb = null;
            Symbol[] symbols = new Symbol[sl.length()];
            int i = 0;
            while (i < sl.length()) {
                symbols[i] = sl.symbolAt(i + 1);
                ++i;
            }
            try {
                this.listener.addSymbols(NameParser.this.getAlphabet(), symbols, 0, symbols.length);
            }
            catch (IllegalAlphabetException ex) {
                throw new BioError(ex);
            }
        }
    }
}

