/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

public class NameTokenization
implements SymbolTokenization {
    private FiniteAlphabet alphabet;
    private transient Map nameToSymbol = null;

    public NameTokenization(FiniteAlphabet fab) {
        this.alphabet = fab;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SymbolTokenization.TokenType getTokenType() {
        return SymbolTokenization.SEPARATED;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    protected Map getNameToSymbol() {
        if (this.nameToSymbol == null) {
            this.nameToSymbol = new HashMap();
            Iterator i = this.alphabet.iterator();
            while (i.hasNext()) {
                Symbol sym = (Symbol)i.next();
                this.nameToSymbol.put(sym.getName(), sym);
            }
            this.nameToSymbol.put("gap", this.getAlphabet().getGapSymbol());
        }
        return this.nameToSymbol;
    }

    public Symbol parseToken(String token) throws IllegalSymbolException {
        Symbol sym = (Symbol)this.getNameToSymbol().get(token);
        if (sym == null) {
            char c = token.charAt(0);
            if (c == '[') {
                throw new IllegalSymbolException("We need to handle ambiguity");
            }
            throw new IllegalSymbolException("Token `" + token + "' does not appear as a named symbol in alphabet `" + this.getAlphabet().getName() + "'");
        }
        return sym;
    }

    public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
        this.getAlphabet().validate(s);
        return s.getName();
    }

    public String tokenizeSymbolList(SymbolList sl) throws IllegalAlphabetException {
        if (sl.getAlphabet() != this.getAlphabet()) {
            throw new IllegalAlphabetException("Alphabet " + sl.getAlphabet().getName() + " does not match " + this.getAlphabet().getName());
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = sl.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            sb.append(sym.getName());
            if (!i.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public StreamParser parseStream(SeqIOListener siol) {
        return new NameStreamParser(siol);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    private class NameStreamParser
    implements StreamParser {
        SeqIOListener listener;
        StringBuffer sb = new StringBuffer();

        NameStreamParser(SeqIOListener l) {
            this.listener = l;
        }

        public void characters(char[] data, int start, int len) {
            this.sb.append(data, start, len);
        }

        public void close() throws IllegalSymbolException {
            String str = this.sb.toString();
            StringTokenizer toke = new StringTokenizer(str, " \n\r");
            ArrayList<Symbol> sl = new ArrayList<Symbol>();
            while (toke.hasMoreTokens()) {
                Symbol sym = NameTokenization.this.parseToken(toke.nextToken());
                sl.add(sym);
            }
        }
    }
}

