/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SeqFileFormer;

public abstract class SeqFileFormerFactory {
    private static Map factories = new HashMap();

    static void addFactory(String format, SeqFileFormerFactory factory) {
        factories.put(format, factory);
    }

    public static final SeqFileFormer makeFormer(String format) throws BioException {
        if (!factories.containsKey(format)) {
            try {
                Class.forName("org.biojava.bio.seq.io." + format + "FileFormer");
            }
            catch (ClassNotFoundException cnfe) {
                throw new BioException("Attempted to load non-existent FileFormer class 'org.biojava.bio.seq.io." + format + "FileFormer'");
            }
            if (!factories.containsKey(format)) {
                throw new BioException("Failed to load non-existent FileFormer class 'org.biojava.bio.seq.io." + format + "FileFormer'");
            }
        }
        return ((SeqFileFormerFactory)factories.get(format)).make();
    }

    protected abstract SeqFileFormer make();
}

