/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

public class SeqIOEventEmitter {
    private SeqIOEventEmitter() {
    }

    public static void getSeqIOEvents(Sequence seq, SeqIOListener listener) throws BioException {
        try {
            listener.startSequence();
            listener.setName(seq.getName());
            listener.setURI(seq.getURN());
            Annotation a = seq.getAnnotation();
            Iterator ai = a.keys().iterator();
            while (ai.hasNext()) {
                Object key = ai.next();
                listener.addSequenceProperty(key, a.getProperty(key));
            }
            List subs = SeqIOEventEmitter.getSubFeatures(seq);
            Collections.sort(subs, Feature.byEmblOrder);
            Iterator fi = subs.iterator();
            while (fi.hasNext()) {
                Feature.Template t = ((Feature)fi.next()).makeTemplate();
                listener.startFeature(t);
                ArrayList keys = new ArrayList();
                keys.addAll(t.annotation.keys());
                Collections.sort(keys);
                Iterator ki = keys.iterator();
                while (ki.hasNext()) {
                    Object key = ki.next();
                    if (key.equals("internal_data")) continue;
                    listener.addFeatureProperty(key, t.annotation.getProperty(key));
                }
                listener.endFeature();
            }
            listener.addSymbols(seq.getAlphabet(), seq.toList().toArray(new Symbol[0]), 0, seq.length());
            listener.endSequence();
        }
        catch (IllegalAlphabetException iae) {
            throw new BioException("An internal error occurred processing symbols of " + seq.toString() + " into SeqIO events");
        }
        catch (ParseException pe) {
            throw new BioException("An internal error occurred processing " + seq.toString() + " into SeqIO events");
        }
    }

    private static List getSubFeatures(FeatureHolder fh) {
        ArrayList<FeatureHolder> subfeat = new ArrayList<FeatureHolder>();
        Iterator fi = fh.features();
        while (fi.hasNext()) {
            FeatureHolder sfh = (FeatureHolder)fi.next();
            subfeat.addAll(SeqIOEventEmitter.getSubFeatures(sfh));
            subfeat.add(sfh);
        }
        return subfeat;
    }
}

