/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.ChunkedSymbolListBuilder;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;

public class TokenParser
implements SymbolParser,
Serializable {
    private FiniteAlphabet alphabet;
    private transient Symbol[] symbolsByChar;

    private void generateTable() {
        HashSet<Symbol> tokenSymbols = new HashSet<Symbol>();
        tokenSymbols.add(this.alphabet.getGapSymbol());
        Iterator si = this.alphabet.iterator();
        while (si.hasNext()) {
            Symbol sym = (Symbol)si.next();
            tokenSymbols.add(sym);
        }
        if (this.alphabet instanceof SimpleAlphabet) {
            Iterator si2 = ((SimpleAlphabet)this.alphabet).ambiguities();
            while (si2.hasNext()) {
                Symbol sym = (Symbol)si2.next();
                tokenSymbols.add(sym);
            }
        }
        int maxIndx = 0;
        Iterator i = tokenSymbols.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            char token = sym.getToken();
            maxIndx = Math.max(maxIndx, Character.toUpperCase(token));
            maxIndx = Math.max(maxIndx, Character.toLowerCase(token));
        }
        this.symbolsByChar = new Symbol[maxIndx + 1];
        Iterator i2 = tokenSymbols.iterator();
        while (i2.hasNext()) {
            Symbol sym = (Symbol)i2.next();
            char token = sym.getToken();
            this.symbolsByChar[Character.toUpperCase((char)token)] = sym;
            this.symbolsByChar[Character.toLowerCase((char)token)] = sym;
        }
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SymbolList parse(String seq) throws IllegalSymbolException {
        int len = seq.length();
        if (len < 100) {
            ArrayList<Symbol> rList = new ArrayList<Symbol>(seq.length());
            int i = 0;
            while (i < seq.length()) {
                rList.add(this.parseCharToken(seq.charAt(i)));
                ++i;
            }
            return new SimpleSymbolList(this.getAlphabet(), rList);
        }
        Symbol[] buffer = new Symbol[256];
        ChunkedSymbolListBuilder builder = new ChunkedSymbolListBuilder();
        int pos = 0;
        while (pos < len) {
            int bufPos = 0;
            while (pos < len && bufPos < buffer.length) {
                buffer[bufPos++] = this.parseCharToken(seq.charAt(pos++));
            }
            try {
                builder.addSymbols(this.alphabet, buffer, 0, bufPos);
            }
            catch (IllegalAlphabetException ex) {
                throw new BioError(ex);
            }
        }
        return builder.makeSymbolList();
    }

    Symbol parseCharToken(char token) throws IllegalSymbolException {
        if (this.symbolsByChar == null) {
            this.generateTable();
        }
        try {
            Symbol s = this.symbolsByChar[token];
            if (s != null) {
                return s;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new IllegalSymbolException("No symbol for token '" + token + "' found in alphabet " + this.alphabet.getName());
    }

    public Symbol parseToken(String token) throws IllegalSymbolException {
        if (token.length() > 1) {
            throw new IllegalSymbolException("All tokens recognized by this parser are single characters.");
        }
        return this.parseCharToken(token.charAt(0));
    }

    public TokenParser(FiniteAlphabet alpha) {
        this.alphabet = alpha;
        this.installChangeListener();
    }

    private void installChangeListener() {
        this.alphabet.addChangeListener(new ChangeListener(){

            public void preChange(ChangeEvent cev) {
            }

            public void postChange(ChangeEvent cev) {
                TokenParser.access$002(TokenParser.this, null);
            }
        });
    }

    public StreamParser parseStream(SeqIOListener listener) {
        return new TPStreamParser(listener);
    }

    static /* synthetic */ Symbol[] access$002(TokenParser x0, Symbol[] x1) {
        x0.symbolsByChar = x1;
        return x1;
    }

    private class TPStreamParser
    implements StreamParser {
        private SeqIOListener listener;
        private Symbol[] buffer = new Symbol[256];

        public TPStreamParser(SeqIOListener l) {
            this.listener = l;
        }

        public void characters(char[] data, int start, int len) throws IllegalSymbolException {
            int cnt = 0;
            while (cnt < len) {
                int bcnt = 0;
                while (cnt < len && bcnt < this.buffer.length) {
                    this.buffer[bcnt++] = TokenParser.this.parseCharToken(data[start + cnt++]);
                }
                try {
                    this.listener.addSymbols(TokenParser.this.getAlphabet(), this.buffer, 0, bcnt);
                }
                catch (IllegalAlphabetException ex) {
                    throw new BioError(ex, "Assertion failed: can't add symbols.");
                }
            }
        }

        public void close() {
        }
    }
}

