/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import java.util.List;
import java.util.Vector;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game.StAXFeatureHandler;
import org.biojava.bio.seq.io.game.StAXHandlerFactory;
import org.biojava.bio.seq.io.game.StAXPropertyHandler;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.SAXException;

public class GAMEDbxrefPropHandler
extends StAXPropertyHandler {
    public static final StAXHandlerFactory GAME_DBXREF_PROP_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEDbxrefPropHandler(staxenv);
        }
    };
    private String XrefDb = null;
    private String DbXrefId = null;

    GAMEDbxrefPropHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.setHandlerCharacteristics("dbxref", true);
        super.addHandler(new ElementRecognizer.ByLocalName("xref_db"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new XrefDbHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("db_xref_id"), new StAXHandlerFactory(){

            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new DbXrefIdHandler();
            }
        });
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        if (this.XrefDb == null || this.DbXrefId == null) {
            throw new SAXException("Malformed <db_xref> ");
        }
        try {
            if (!this.staxenv.featureTemplate.annotation.containsProperty("dbxref_list")) {
                this.staxenv.featureTemplate.annotation.setProperty("dbxref_list", new Vector());
            }
            List dbxrefList = (List)this.staxenv.featureTemplate.annotation.getProperty("dbxref_list");
            dbxrefList.add(new DbXrefElement(this.XrefDb, this.DbXrefId));
        }
        catch (ChangeVetoException cve) {
            System.err.println("GAMEDbxrefPropHandler: change vetoed.");
        }
    }

    private class DbXrefIdHandler
    extends StringElementHandlerBase {
        private DbXrefIdHandler() {
        }

        protected void setStringValue(String s) {
            GAMEDbxrefPropHandler.this.DbXrefId = s.trim();
        }
    }

    private class XrefDbHandler
    extends StringElementHandlerBase {
        private XrefDbHandler() {
        }

        protected void setStringValue(String s) {
            GAMEDbxrefPropHandler.this.XrefDb = s.trim();
        }
    }

    public class DbXrefElement {
        private String XrefDb;
        private String DbXrefId;

        private DbXrefElement(String XrefDb, String DbXrefId) {
            this.XrefDb = XrefDb;
            this.DbXrefId = DbXrefId;
        }

        public String getXrefDb() {
            return this.XrefDb;
        }

        public String getDbXrefId() {
            return this.DbXrefId;
        }
    }
}

