/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ragbag.RagbagCachedSequence;
import org.biojava.bio.seq.ragbag.RagbagFilterFactory;
import org.biojava.bio.seq.ragbag.RagbagIdleSequenceBuilder;
import org.biojava.bio.seq.ragbag.RagbagSequence;
import org.biojava.utils.cache.Cache;

class RagbagParsedCachedSequence
extends RagbagCachedSequence {
    private RagbagFilterFactory filterFactory;

    public RagbagParsedCachedSequence(String name, String urn, Cache cache, RagbagFilterFactory filterFactory) {
        super(name, urn, cache);
        this.filterFactory = filterFactory;
        System.out.println("RagbagParsedCachedSequence constructor: " + name + " " + urn);
    }

    public void makeSequence() throws BioException {
        super.makeSequence();
        try {
            RagbagSequence seq = new RagbagSequence("", "", this.filterFactory.wrap(new RagbagIdleSequenceBuilder()));
            seq.addSequenceFile(new File(this.seqFilename));
            if (this.annotFilenames != null) {
                Iterator ai = this.annotFilenames.iterator();
                while (ai.hasNext()) {
                    File currAnnotFile = new File((String)ai.next());
                    seq.addFeatureFile(currAnnotFile);
                }
            }
            seq.makeSequence();
        }
        catch (BioException be) {
            throw new BioError(be);
        }
    }
}

