/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.ragbag;

import java.io.File;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.ragbag.RagbagAbstractSequence;
import org.biojava.bio.seq.ragbag.RagbagFileParser;
import org.biojava.bio.seq.ragbag.RagbagParserFactory;
import org.biojava.bio.seq.ragbag.RagbagSequenceItf;

class RagbagSequence
extends RagbagAbstractSequence
implements RagbagSequenceItf {
    private SequenceBuilder builder;
    private boolean haveSequence = false;
    private String name;
    private String urn;

    public RagbagSequence(String name, String urn) {
        this.builder = new SimpleSequenceBuilder();
        this.name = name;
        this.urn = urn;
        System.out.println("RagbagSequence constructor: " + name + " " + urn);
    }

    public RagbagSequence(String name, String urn, SequenceBuilder builder) {
        this.builder = builder;
        this.name = name;
        this.urn = urn;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.urn;
    }

    public void addFeatureFile(File thisFile) throws BioException {
        if (!thisFile.exists() || !thisFile.isFile()) {
            throw new BioException("RagbagSequence: can't use the specified file");
        }
        RagbagFileParser parser = RagbagParserFactory.FACTORY.getParser(thisFile);
        parser.setListener(this.builder);
        parser.parse();
    }

    public void addFeatureFile(String filename) throws BioException {
        File thisFile = new File(filename);
        this.addFeatureFile(thisFile);
    }

    public void addSequenceFile(File thisFile) throws BioException {
        if (this.haveSequence) {
            throw new BioException("RagbagSequence: addSequenceFile called twice!");
        }
        this.addFeatureFile(thisFile);
        this.haveSequence = true;
    }

    public void makeSequence() throws BioException {
        if (!this.haveSequence) {
            throw new BioException("RagbagSequence: no sequence to instantiate!");
        }
        this.sequence = this.builder.makeSequence();
    }
}

