/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;

class HashedAlphabetIndex
extends AbstractChangeable
implements AlphabetIndex {
    private static final Comparator cmp = new HashComparator();
    private final FiniteAlphabet alpha;
    private final Symbol[] symbols;
    private final int[] hashes;

    public FiniteAlphabet getAlphabet() {
        return this.alpha;
    }

    public int indexForSymbol(Symbol s) throws IllegalSymbolException {
        int indx = Arrays.binarySearch(this.hashes, s.hashCode());
        if (indx < 0) {
            this.getAlphabet().validate(s);
            if (s instanceof AtomicSymbol) {
                throw new BioError("Assertion Failure: Symbol " + s.getName() + " was not an indexed member of the alphabet " + this.getAlphabet().getName() + " despite being in the alphabet.");
            }
            throw new IllegalSymbolException("Symbol must be atomic to be indexed.");
        }
        return indx;
    }

    public Symbol symbolForIndex(int i) throws IndexOutOfBoundsException {
        return this.symbols[i];
    }

    public HashedAlphabetIndex(FiniteAlphabet alpha) {
        alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
        this.alpha = alpha;
        this.symbols = new Symbol[alpha.size()];
        this.hashes = new int[alpha.size()];
        int i = 0;
        Iterator s = alpha.iterator();
        while (s.hasNext()) {
            this.symbols[i++] = (Symbol)s.next();
        }
        Arrays.sort(this.symbols, cmp);
        i = 0;
        while (i < this.symbols.length) {
            this.hashes[i] = this.symbols[i].hashCode();
            ++i;
        }
    }

    private static class HashComparator
    implements Comparator {
        private HashComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof HashComparator;
        }

        public int compare(Object a, Object b) {
            return a.hashCode() - b.hashCode();
        }
    }
}

