/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import java.util.HashSet;
import java.util.Iterator;
import org.biojava.utils.query.Follow;
import org.biojava.utils.query.JavaType;
import org.biojava.utils.query.OperationException;
import org.biojava.utils.query.QueryTools;
import org.biojava.utils.query.Queryable;
import org.biojava.utils.query.Type;
import org.biojava.utils.query.TypeCastException;

public abstract class Filter
extends Follow {
    public Queryable follow(Object item) throws OperationException {
        if (this.accept(item)) {
            return new Queryable.Singleton(item);
        }
        return new Queryable.Empty(this.getOutputType());
    }

    public Queryable apply(Queryable items) throws OperationException {
        HashSet matches = new HashSet();
        Iterator i = items.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!this.accept(o)) continue;
            matches.add(o);
        }
        return QueryTools.createQueryable(matches, this.getOutputType());
    }

    public abstract boolean accept(Object var1) throws OperationException;

    public static final class CompareInteger
    extends Filter {
        private final int value;
        private final Comparison cmp;
        public static final Comparison LT = new Comparison(){

            public boolean compare(int a, int b) {
                return a < b;
            }
        };
        public static final Comparison LTEQ = new Comparison(){

            public boolean compare(int a, int b) {
                return a <= b;
            }
        };
        public static final Comparison EQ = new Comparison(){

            public boolean compare(int a, int b) {
                return a == b;
            }
        };
        public static final Comparison GTEQ = new Comparison(){

            public boolean compare(int a, int b) {
                return a >= b;
            }
        };
        public static final Comparison GT = new Comparison(){

            public boolean compare(int a, int b) {
                return a > b;
            }
        };
        public static final Comparison NEQ = new Comparison(){

            public boolean compare(int a, int b) {
                return a != b;
            }
        };
        static /* synthetic */ Class class$java$lang$Integer;

        public CompareInteger(int value, Comparison cmp) {
            this.value = value;
            this.cmp = cmp;
        }

        public int getValue() {
            return this.value;
        }

        public Comparison getComparsion() {
            return this.cmp;
        }

        public boolean accept(Object item) {
            Integer i = (Integer)item;
            return this.cmp.compare(i, this.value);
        }

        public Type getInputType() {
            return JavaType.getType(class$java$lang$Integer == null ? (class$java$lang$Integer = CompareInteger.class$("java.lang.Integer")) : class$java$lang$Integer);
        }

        public Type getOutputType() {
            return JavaType.getType(class$java$lang$Integer == null ? (class$java$lang$Integer = CompareInteger.class$("java.lang.Integer")) : class$java$lang$Integer);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        public static interface Comparison {
            public boolean compare(int var1, int var2);
        }
    }

    public static final class ByType
    extends Filter {
        private Type inputType;
        private Type outputType;

        public ByType(Type inputType, Type outputType) {
            if (!inputType.isAssignableFrom(outputType)) {
                throw new TypeCastException("Can't filter to a type that is not a subtype: " + inputType + " " + outputType);
            }
            this.inputType = inputType;
            this.outputType = outputType;
        }

        public boolean accept(Object item) {
            return this.getOutputType().isInstance(item);
        }

        public Type getInputType() {
            return this.inputType;
        }

        public Type getOutputType() {
            return this.outputType;
        }

        public int hashCode() {
            return this.getInputType().hashCode() ^ this.getOutputType().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ByType) {
                ByType fbt = (ByType)o;
                return this.getInputType().equals(fbt.getInputType()) && this.getOutputType().equals(fbt.getOutputType());
            }
            return false;
        }

        public String toString() {
            return "Filter.ByType[" + this.inputType + " -> " + this.outputType + "]";
        }
    }

    public static final class Equals
    extends Filter {
        private final Object item;
        private final Type type;

        public Equals(Object item, Type type) {
            this.item = item;
            this.type = type;
        }

        public Object getItem() {
            return this.item;
        }

        public boolean accept(Object item) {
            return this.item.equals(item);
        }

        public Type getInputType() {
            return this.type;
        }

        public Type getOutputType() {
            return this.type;
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Equals) {
                Equals fe = (Equals)o;
                return this.item.equals(fe.item);
            }
            return false;
        }

        public String toString() {
            return "Filter.Equals[" + this.item + "]";
        }
    }

    public static final class Not
    extends Filter {
        private final Filter filter;

        public Not(Filter filter) {
            this.filter = filter;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public boolean accept(Object item) throws OperationException {
            return !this.filter.accept(item);
        }

        public Type getInputType() {
            return this.getFilter().getInputType();
        }

        public Type getOutputType() {
            return this.getFilter().getOutputType();
        }
    }

    public static final class AcceptAll
    extends Filter {
        private final Type type;

        public AcceptAll(Type type) {
            this.type = type;
        }

        public boolean accept(Object item) {
            return true;
        }

        public Type getInputType() {
            return this.type;
        }

        public Type getOutputType() {
            return this.type;
        }
    }

    public static final class RejectAll
    extends Filter {
        private final Type type;

        public RejectAll(Type type) {
            this.type = type;
        }

        public boolean accept(Object item) {
            return false;
        }

        public Type getInputType() {
            return this.type;
        }

        public Type getOutputType() {
            return this.type;
        }
    }
}

