/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.util.Arrays;
import java.util.List;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.PairDPCursor;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class LightPairDPCursor
implements PairDPCursor {
    private int[] pos;
    private boolean flip;
    private SymbolList[] seqs;
    private double[][][] columns;
    private double[][][] emissions;
    protected BackPointer[][][] bPointers;
    protected int numStates;
    protected double[] zeroCol;
    protected BackPointer[] emptyBP;
    protected int[] depth;
    protected EmissionCache eCache;

    public LightPairDPCursor(SymbolList symbolList, SymbolList symbolList2, int n, int n2, int n3, EmissionCache emissionCache) throws IllegalSymbolException {
        this.numStates = n3;
        this.zeroCol = new double[this.numStates];
        int n4 = 0;
        while (n4 < this.zeroCol.length) {
            this.zeroCol[n4] = Double.NaN;
            ++n4;
        }
        this.emptyBP = new BackPointer[n3];
        this.pos = new int[2];
        this.pos[0] = 0;
        this.pos[1] = 0;
        this.seqs = new SymbolList[2];
        this.seqs[0] = symbolList;
        this.seqs[1] = symbolList2;
        this.depth = new int[2];
        this.depth[0] = n;
        this.depth[1] = n2;
        this.eCache = emissionCache;
        boolean bl = this.flip = this.seqs[1].length() > this.seqs[0].length();
        if (this.flip) {
            this.columns = new double[this.depth[0]][this.seqs[1].length() + 2][n3];
            this.emissions = new double[this.depth[0]][this.seqs[1].length() + 2][];
            this.bPointers = new BackPointer[this.depth[0]][this.seqs[1].length() + 2][n3];
        } else {
            this.columns = new double[this.depth[1]][this.seqs[0].length() + 2][n3];
            this.emissions = new double[this.depth[1]][this.seqs[0].length() + 2][];
            this.bPointers = new BackPointer[this.depth[1]][this.seqs[0].length() + 2][n3];
        }
        int n5 = 0;
        while (n5 < this.columns.length) {
            double[][] dArray = this.columns[n5];
            int n6 = 0;
            while (n6 < dArray.length) {
                double[] dArray2 = dArray[n6];
                int n7 = 0;
                while (n7 < dArray2.length) {
                    dArray2[n7] = Double.NaN;
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        this.calcEmissions(this.emissions[0]);
    }

    private void calcEmissions(double[][] dArray) throws IllegalSymbolException {
        if (this.flip) {
            Symbol[] symbolArray = new Symbol[2];
            List<Symbol> list = Arrays.asList(symbolArray);
            int n = this.pos[0];
            symbolArray[0] = n < 1 || n > this.seqs[0].length() ? AlphabetManager.getGapSymbol() : this.seqs[0].symbolAt(n);
            int n2 = 0;
            while (n2 <= this.seqs[1].length() + 1) {
                symbolArray[1] = n2 < 1 || n2 > this.seqs[1].length() ? AlphabetManager.getGapSymbol() : this.seqs[1].symbolAt(n2);
                dArray[n2] = this.eCache.getEmissions(list);
                ++n2;
            }
        } else {
            Symbol[] symbolArray = new Symbol[2];
            List<Symbol> list = Arrays.asList(symbolArray);
            int n = this.pos[1];
            symbolArray[1] = n < 1 || n > this.seqs[1].length() ? AlphabetManager.getGapSymbol() : this.seqs[1].symbolAt(n);
            int n3 = 0;
            while (n3 <= this.seqs[0].length() + 1) {
                symbolArray[0] = n3 < 1 || n3 > this.seqs[0].length() ? AlphabetManager.getGapSymbol() : this.seqs[0].symbolAt(n3);
                dArray[n3] = this.eCache.getEmissions(list);
                ++n3;
            }
        }
    }

    public int[] getDepth() {
        return this.depth;
    }

    public boolean hasNext() {
        int n = this.flip ? 0 : 1;
        return this.pos[n] <= this.seqs[n].length() + 1;
    }

    public void next(Cell[][] cellArray) throws IllegalSymbolException {
        if (this.flip) {
            Object object;
            Object object2;
            int n;
            int n2 = 0;
            while (n2 < this.depth[0]) {
                n = this.pos[0] - n2;
                boolean bl = n < 0 || n > this.seqs[0].length() + 1;
                object2 = cellArray[n2];
                object = this.columns[n2];
                double[][] dArray = this.emissions[n2];
                BackPointer[][] backPointerArray = this.bPointers[n2];
                int n3 = 0;
                while (n3 < this.depth[1]) {
                    int n4 = this.pos[1] - n3;
                    boolean bl2 = n4 < 0 || n4 > this.seqs[1].length() + 1;
                    Cell cell = object2[n3];
                    if (bl || bl2) {
                        cell.scores = this.zeroCol;
                        cell.emissions = this.zeroCol;
                        cell.backPointers = this.emptyBP;
                    } else {
                        cell.scores = object[n4];
                        cell.emissions = dArray[n4];
                        cell.backPointers = backPointerArray[n4];
                    }
                    ++n3;
                }
                ++n2;
            }
            if (this.pos[1] <= this.seqs[1].length()) {
                this.pos[1] = this.pos[1] + 1;
            } else {
                this.pos[1] = 0;
                this.pos[0] = this.pos[0] + 1;
                n = this.depth[0];
                double[][] dArray = this.columns[n - 1];
                object2 = this.emissions[n - 1];
                object = this.bPointers[n - 1];
                int n5 = 1;
                while (n5 < n) {
                    this.columns[n5] = this.columns[n5 - 1];
                    this.emissions[n5] = this.emissions[n5 - 1];
                    this.bPointers[n5] = this.bPointers[n5 - 1];
                    ++n5;
                }
                this.columns[0] = dArray;
                this.emissions[0] = (double[][])object2;
                this.bPointers[0] = (BackPointer[][])object;
                this.calcEmissions((double[][])object2);
            }
        } else {
            Object object;
            double[][] dArray;
            int n;
            int n6 = 0;
            while (n6 < this.depth[1]) {
                n = this.pos[1] - n6;
                boolean bl = n < 0 || n > this.seqs[1].length() + 1;
                dArray = this.columns[n6];
                object = this.emissions[n6];
                BackPointer[][] backPointerArray = this.bPointers[n6];
                int n7 = 0;
                while (n7 < this.depth[0]) {
                    int n8 = this.pos[0] - n7;
                    boolean bl3 = n8 < 0 || n8 > this.seqs[0].length() + 1;
                    Cell cell = cellArray[n7][n6];
                    if (bl || bl3) {
                        cell.scores = this.zeroCol;
                        cell.emissions = this.zeroCol;
                        cell.backPointers = this.emptyBP;
                    } else {
                        cell.scores = dArray[n8];
                        cell.emissions = object[n8];
                        cell.backPointers = backPointerArray[n8];
                    }
                    ++n7;
                }
                ++n6;
            }
            if (this.pos[0] <= this.seqs[0].length()) {
                this.pos[0] = this.pos[0] + 1;
            } else {
                this.pos[0] = 0;
                this.pos[1] = this.pos[1] + 1;
                n = this.depth[1];
                double[][] dArray2 = this.columns[n - 1];
                dArray = this.emissions[n - 1];
                object = this.bPointers[n - 1];
                int n9 = 1;
                while (n9 < n) {
                    this.columns[n9] = this.columns[n9 - 1];
                    this.emissions[n9] = this.emissions[n9 - 1];
                    this.bPointers[n9] = this.bPointers[n9 - 1];
                    ++n9;
                }
                this.columns[0] = dArray2;
                this.emissions[0] = dArray;
                this.bPointers[0] = (BackPointer[][])object;
                this.calcEmissions(dArray);
            }
        }
    }

    public Cell[][] press() {
        Cell[][] cellArray = new Cell[this.depth[0]][this.depth[1]];
        int n = 0;
        while (n < cellArray.length) {
            Cell[] cellArray2 = cellArray[n];
            int n2 = 0;
            while (n2 < cellArray2.length) {
                cellArray2[n2] = new Cell();
                ++n2;
            }
            ++n;
        }
        return cellArray;
    }
}

