/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.sequence.AbstractForwarder;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class LayeredRenderer
extends AbstractForwarder
implements SequenceRenderer {
    public static final ChangeType RENDERER = new ChangeType("The renderer has changed.", "org.biojava.bio.gui.sequence.LayeredRenderer", "RENDERER");
    private SequenceRenderer lineRenderer;

    public LayeredRenderer() {
    }

    public LayeredRenderer(SequenceRenderer sequenceRenderer) {
        try {
            this.setLineRenderer(sequenceRenderer);
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException, "Assertion Failure: Should have no listeners");
        }
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, int n, int n2) {
        double d = 0.0;
        List list = this.layer((Sequence)sequenceRenderContext.getSequence());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FeatureHolder featureHolder = (FeatureHolder)iterator.next();
            SubSequenceRenderContext subSequenceRenderContext = new SubSequenceRenderContext(sequenceRenderContext, featureHolder);
            d += this.getLineRenderer().getDepth(subSequenceRenderContext, n, n2);
        }
        return d;
    }

    public SequenceRenderer getLineRenderer() {
        return this.lineRenderer;
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext) {
        return this.getLineRenderer().getMinimumLeader(sequenceRenderContext);
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext) {
        return this.getLineRenderer().getMinimumTrailer(sequenceRenderContext);
    }

    protected List layer(Sequence sequence) {
        ArrayList<SimpleFeatureHolder> arrayList = new ArrayList<SimpleFeatureHolder>();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = sequence.features();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            Location location = feature.getLocation();
            if (!location.isContiguous()) {
                location = new RangeLocation(location.getMin(), location.getMax());
            }
            Iterator iterator2 = arrayList2.iterator();
            Iterator iterator3 = arrayList.iterator();
            SimpleFeatureHolder simpleFeatureHolder = null;
            List<Location> list = null;
            block3: while (iterator2.hasNext()) {
                List list2 = (List)iterator2.next();
                SimpleFeatureHolder simpleFeatureHolder2 = (SimpleFeatureHolder)iterator3.next();
                Iterator iterator4 = list2.iterator();
                while (iterator4.hasNext()) {
                    Location location2 = (Location)iterator4.next();
                    if (location2.overlaps(location)) continue block3;
                }
                list = list2;
                simpleFeatureHolder = simpleFeatureHolder2;
                break;
            }
            if (list == null) {
                list = new ArrayList<Location>();
                arrayList2.add(list);
                simpleFeatureHolder = new SimpleFeatureHolder();
                arrayList.add(simpleFeatureHolder);
            }
            list.add(location);
            try {
                simpleFeatureHolder.addFeature(feature);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Pants");
            }
        }
        return arrayList;
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, int n, int n2) {
        List list = this.layer((Sequence)sequenceRenderContext.getSequence());
        SequenceRenderer sequenceRenderer = this.getLineRenderer();
        double d = 0.0;
        double d2 = sequenceRenderer.getDepth(sequenceRenderContext, n, n2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FeatureHolder featureHolder = (FeatureHolder)iterator.next();
            SubSequenceRenderContext subSequenceRenderContext = new SubSequenceRenderContext(sequenceRenderContext, featureHolder);
            int n3 = sequenceRenderContext.getDirection();
            if (n3 == 0) {
                graphics2D.translate(0.0, d);
            } else {
                graphics2D.translate(d, 0.0);
            }
            sequenceRenderer.paint(graphics2D, subSequenceRenderContext, n, n2);
            if (n3 == 0) {
                graphics2D.translate(0.0, -d);
            } else {
                graphics2D.translate(-d, 0.0);
            }
            d += d2;
        }
    }

    public void setLineRenderer(SequenceRenderer sequenceRenderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERER);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, RENDERER, sequenceRenderer, this.lineRenderer));
                changeSupport.firePreChangeEvent(changeEvent);
                this.lineRenderer = sequenceRenderer;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.lineRenderer = sequenceRenderer;
        }
    }
}

