/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.gui.sequence.AbstractForwarder;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class ZiggyFeatureRenderer
extends AbstractForwarder
implements FeatureRenderer,
Serializable {
    private Paint outline = Color.black;
    private Paint fill = Color.yellow;
    private double blockDepth = 10.0;
    private double zigDepth = 5.0;

    public double getBlockDepth() {
        return this.blockDepth;
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext) {
        return 2.0 * this.zigDepth + this.blockDepth + 1.0;
    }

    public Paint getFill() {
        return this.fill;
    }

    public Paint getOutline() {
        return this.outline;
    }

    public double getZigDepth() {
        return this.zigDepth;
    }

    public void renderFeature(Graphics2D graphics2D, Feature feature, SequenceRenderContext sequenceRenderContext) {
        Location location = feature.getLocation();
        Iterator iterator = location.blockIterator();
        Location location2 = null;
        if (iterator.hasNext()) {
            location2 = (Location)iterator.next();
            this.renderLocation(graphics2D, location2, sequenceRenderContext);
        }
        while (iterator.hasNext()) {
            Location location3 = (Location)iterator.next();
            this.renderLink(graphics2D, feature, location2, location3, sequenceRenderContext);
            this.renderLocation(graphics2D, location3, sequenceRenderContext);
            location2 = location3;
        }
    }

    private void renderLink(Graphics2D graphics2D, Feature feature, Location location, Location location2, SequenceRenderContext sequenceRenderContext) {
        Point2D.Double double_;
        Point2D.Double double_2;
        Point2D.Double double_3;
        Line2D.Double double_4 = new Line2D.Double();
        if (sequenceRenderContext.getDirection() == 0) {
            if (feature instanceof StrandedFeature && ((StrandedFeature)feature).getStrand() == StrandedFeature.NEGATIVE) {
                double d = sequenceRenderContext.sequenceToGraphics(location2.getMin());
                double d2 = sequenceRenderContext.sequenceToGraphics(location.getMax() + 1);
                double d3 = (d + d2) * 0.5;
                double_3 = new Point2D.Double(d, this.zigDepth + this.blockDepth);
                double_2 = new Point2D.Double(d3, this.zigDepth + this.blockDepth + this.zigDepth);
                double_ = new Point2D.Double(d2, this.zigDepth + this.blockDepth);
            } else {
                double d = sequenceRenderContext.sequenceToGraphics(location.getMax());
                double d4 = sequenceRenderContext.sequenceToGraphics(location2.getMin() + 1);
                double d5 = (d + d4) * 0.5;
                double_3 = new Point2D.Double(d, this.zigDepth);
                double_2 = new Point2D.Double(d5, 0.0);
                double_ = new Point2D.Double(d4, this.zigDepth);
            }
        } else if (feature instanceof StrandedFeature && ((StrandedFeature)feature).getStrand() == StrandedFeature.NEGATIVE) {
            double d = sequenceRenderContext.sequenceToGraphics(location2.getMin());
            double d6 = sequenceRenderContext.sequenceToGraphics(location.getMax() + 1);
            double d7 = (d + d6) * 0.5;
            double_3 = new Point2D.Double(this.zigDepth + this.blockDepth, d);
            double_2 = new Point2D.Double(this.zigDepth + this.blockDepth + this.zigDepth, d7);
            double_ = new Point2D.Double(this.zigDepth + this.blockDepth, d6);
        } else {
            double d = sequenceRenderContext.sequenceToGraphics(location.getMax());
            double d8 = sequenceRenderContext.sequenceToGraphics(location2.getMin() + 1);
            double d9 = (d + d8) * 0.5;
            double_3 = new Point2D.Double(this.zigDepth, d);
            double_2 = new Point2D.Double(0.0, d9);
            double_ = new Point2D.Double(this.zigDepth, d8);
        }
        double_4.setLine(double_3, double_2);
        graphics2D.draw(double_4);
        double_4.setLine(double_2, double_);
        graphics2D.draw(double_4);
    }

    private void renderLocation(Graphics2D graphics2D, Location location, SequenceRenderContext sequenceRenderContext) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double d = sequenceRenderContext.sequenceToGraphics(location.getMin());
        double d2 = sequenceRenderContext.sequenceToGraphics(location.getMax() + 1);
        if (sequenceRenderContext.getDirection() == 0) {
            double_.setFrame(d, this.zigDepth, d2 - d, this.blockDepth);
        } else {
            double_.setFrame(this.zigDepth, d, this.blockDepth, d2 - d);
        }
        if (this.fill != null) {
            graphics2D.setPaint(this.fill);
            graphics2D.fill(double_);
        }
        if (this.outline != null) {
            graphics2D.setPaint(this.outline);
            graphics2D.draw(double_);
        }
    }

    public void setBlockDepth(double d) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT);
                changeSupport.firePreChangeEvent(changeEvent);
                this.blockDepth = d;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.blockDepth = d;
        }
    }

    public void setFill(Paint paint) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.REPAINT);
                changeSupport.firePreChangeEvent(changeEvent);
                this.fill = paint;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.fill = paint;
        }
    }

    public void setOutline(Paint paint) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.REPAINT);
                changeSupport.firePreChangeEvent(changeEvent);
                this.outline = paint;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.outline = paint;
        }
    }

    public void setZigDepth(double d) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT);
                changeSupport.firePreChangeEvent(changeEvent);
                this.zigDepth = d;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.zigDepth = d;
        }
    }
}

