/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.Serializable;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.AbstractSequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.utils.ChangeVetoException;

public class AnnotatedSequenceDB
extends AbstractSequenceDB
implements SequenceDB,
Serializable {
    private final SequenceDB parent;
    private final SequenceAnnotator annotator;

    public AnnotatedSequenceDB(SequenceDB sequenceDB, SequenceAnnotator sequenceAnnotator) {
        this.parent = sequenceDB;
        this.annotator = sequenceAnnotator;
    }

    protected Sequence doAnnotation(Sequence sequence) throws BioException {
        try {
            return this.annotator.annotate(sequence);
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BioException(illegalAlphabetException, "Couldn't apply annotator " + this.annotator.toString() + " to " + sequence.getURN());
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioException(changeVetoException, "Couldn't apply annotator " + this.annotator.toString() + " to " + sequence.getURN());
        }
    }

    public String getName() {
        return String.valueOf(this.parent.getName()) + " (" + this.annotator.toString() + ")";
    }

    public SequenceDB getParent() {
        return this.parent;
    }

    public Sequence getSequence(String string) throws BioException {
        return this.doAnnotation(this.parent.getSequence(string));
    }

    public Set ids() {
        return this.parent.ids();
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            SequenceIterator pi;
            {
                this.pi = AnnotatedSequenceDB.this.parent.sequenceIterator();
            }

            public boolean hasNext() {
                return this.pi.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return AnnotatedSequenceDB.this.doAnnotation(this.pi.nextSequence());
            }
        };
    }
}

