/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBWrapper;

public class CachingSequenceDB
extends SequenceDBWrapper {
    private transient Map cache = new HashMap();

    public CachingSequenceDB(SequenceDB sequenceDB) {
        super(sequenceDB);
    }

    public String getName() {
        return this.getParent().getName();
    }

    public Sequence getSequence(String string) throws BioException {
        Sequence sequence;
        SoftReference softReference = (SoftReference)this.cache.get(string);
        if (softReference == null) {
            sequence = this.getParent().getSequence(string);
            this.cache.put(string, new SoftReference<Sequence>(sequence));
        } else {
            sequence = (Sequence)softReference.get();
            if (sequence == null) {
                sequence = this.getParent().getSequence(string);
                this.cache.put(string, new SoftReference<Sequence>(sequence));
            }
        }
        return sequence;
    }

    public Set ids() {
        return this.getParent().ids();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.cache = new HashMap();
    }
}

