/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class AssembledSymbolList
extends AbstractSymbolList {
    private int length = 0;
    private SortedMap components = new TreeMap(Location.naturalOrder);
    private List componentList = new ArrayList();
    private static final Symbol N;

    static {
        try {
            N = DNATools.getDNA().getParser("token").parseToken("n");
        }
        catch (BioException bioException) {
            throw new BioError(bioException);
        }
    }

    public Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    public SymbolList getComponentSymbols(Location location) {
        ComponentFeature componentFeature = (ComponentFeature)this.components.get(location);
        return componentFeature.getSymbols();
    }

    public int length() {
        return this.length;
    }

    public Location locationOfPoint(int n) {
        int n2 = 0;
        int n3 = this.componentList.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Location location = (Location)this.componentList.get(n4);
            if (location.contains(n)) {
                return location;
            }
            if (n < location.getMin()) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return null;
    }

    public Location locationUpstreamOfPoint(int n) {
        int n2 = 0;
        int n3 = this.componentList.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Location location = (Location)this.componentList.get(n4);
            if (location.contains(n)) {
                return location;
            }
            if (n < location.getMin()) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        try {
            return (Location)this.componentList.get(Math.max(n3, n2) + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void putComponent(Location location, ComponentFeature componentFeature) {
        this.components.put(location, componentFeature);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public void removeComponent(Location location) {
        this.components.remove(location);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public void setLength(int n) {
        this.length = n;
    }

    public SymbolList subList(int n, int n2) {
        Location location = this.locationOfPoint(n);
        if (location != null && location.contains(n2)) {
            SymbolList symbolList = this.getComponentSymbols(location);
            int n3 = n - location.getMin() + 1;
            int n4 = n2 - location.getMin() + 1;
            return symbolList.subList(n3, n4);
        }
        return super.subList(n, n2);
    }

    public String subStr(int n, int n2) {
        if (n < 1 || n2 > this.length) {
            throw new IndexOutOfBoundsException("Range out of bounds: " + n + " - " + n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 <= n2) {
            int n4;
            int n5;
            Location location = this.locationOfPoint(n3);
            if (location != null) {
                SymbolList symbolList = this.getComponentSymbols(location);
                n5 = Math.max(1, n3 - location.getMin() + 1);
                int n6 = Math.min(location.getMax() - location.getMin() + 1, n2 - location.getMin() + 1);
                stringBuffer.append(symbolList.subStr(n5, n6));
                n3 += n6 - n5 + 1;
                continue;
            }
            location = this.locationUpstreamOfPoint(n3);
            if (location != null) {
                n4 = Math.min(location.getMin(), n2) - n3;
                n3 = location.getMin();
            } else {
                n4 = n2 - n3 + 1;
                n3 = n2 + 1;
            }
            n5 = 0;
            while (n5 < n4) {
                stringBuffer.append(N.getToken());
                ++n5;
            }
        }
        return stringBuffer.toString();
    }

    public Symbol symbolAt(int n) {
        Location location = this.locationOfPoint(n);
        if (location != null) {
            SymbolList symbolList = this.getComponentSymbols(location);
            return symbolList.symbolAt(n - location.getMin() + 1);
        }
        return N;
    }
}

