/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.EmblProcessor;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.seq.io.SwissprotProcessor;
import org.biojava.bio.seq.io.SymbolParser;

public class SeqIOTools {
    private static SequenceBuilderFactory _emblBuilderFactory;
    private static SequenceBuilderFactory _genbankBuilderFactory;
    private static SequenceBuilderFactory _swissprotBuilderFactory;
    private static SequenceBuilderFactory _fastaBuilderFactory;

    private SeqIOTools() {
    }

    private static SymbolParser getDNAParser() {
        try {
            return DNATools.getDNA().getParser("token");
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Assertion failing: Couldn't get DNA token parser");
        }
    }

    public static SequenceBuilderFactory getEmblBuilderFactory() {
        if (_emblBuilderFactory == null) {
            _emblBuilderFactory = new EmblProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _emblBuilderFactory;
    }

    public static SequenceBuilderFactory getFastaBuilderFactory() {
        if (_fastaBuilderFactory == null) {
            _fastaBuilderFactory = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _fastaBuilderFactory;
    }

    public static SequenceBuilderFactory getGenbankBuilderFactory() {
        if (_genbankBuilderFactory == null) {
            _genbankBuilderFactory = new GenbankProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _genbankBuilderFactory;
    }

    private static SymbolParser getProteinParser() {
        try {
            return DNATools.getDNA().getParser("token");
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Assertion failing: Couldn't get PROTEIN token parser");
        }
    }

    public static SequenceBuilderFactory getSwissprotBuilderFactory() {
        if (_swissprotBuilderFactory == null) {
            _swissprotBuilderFactory = new SwissprotProcessor.Factory(SimpleSequenceBuilder.FACTORY);
        }
        return _swissprotBuilderFactory;
    }

    public static SequenceIterator readEmbl(BufferedReader bufferedReader) {
        return new StreamReader(bufferedReader, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getEmblBuilderFactory());
    }

    public static SequenceIterator readFastaDNA(BufferedReader bufferedReader) {
        return new StreamReader(bufferedReader, (SequenceFormat)new FastaFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceIterator readFastaProtein(BufferedReader bufferedReader) {
        return new StreamReader(bufferedReader, (SequenceFormat)new FastaFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getFastaBuilderFactory());
    }

    public static SequenceIterator readGenbank(BufferedReader bufferedReader) {
        return new StreamReader(bufferedReader, (SequenceFormat)new GenbankFormat(), SeqIOTools.getDNAParser(), SeqIOTools.getGenbankBuilderFactory());
    }

    public static SequenceIterator readSwissprot(BufferedReader bufferedReader) {
        return new StreamReader(bufferedReader, (SequenceFormat)new EmblLikeFormat(), SeqIOTools.getProteinParser(), SeqIOTools.getSwissprotBuilderFactory());
    }
}

