/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.bio.seq.io.SwissprotFeatureTableParser;

public class SwissprotProcessor
extends SequenceBuilderFilter {
    public static final String PROPERTY_SWISSPROT_ACCESSIONS = "swissprot.accessions";
    public static final String PROPERTY_SWISSPROT_COMMENT = "swissprot.comment";
    private boolean mBadFeature = false;
    private SwissprotFeatureTableParser features;
    private static HashSet featureKeys = null;
    private List accessions = new ArrayList();

    public SwissprotProcessor(SequenceBuilder sequenceBuilder) {
        super(sequenceBuilder);
        this.features = new SwissprotFeatureTableParser(this, "SWISSPROT");
    }

    public void addSequenceProperty(Object object, Object object2) throws ParseException {
        try {
            if (this.mBadFeature) {
                String string = object2.toString();
                if (object.equals("FT") && string.charAt(0) != ' ') {
                    this.mBadFeature = false;
                    this.features.startFeature(string.substring(0, 8).trim());
                    this.features.featureData(string.substring(9));
                }
            } else {
                if (this.features.inFeature() && !object.equals("FT")) {
                    this.features.endFeature();
                }
                if (object.equals("FT")) {
                    String string = object2.toString();
                    if (string.charAt(0) != ' ') {
                        if (this.features.inFeature()) {
                            this.features.endFeature();
                        }
                        this.features.startFeature(string.substring(0, 8).trim());
                    }
                    this.features.featureData(string.substring(9));
                } else {
                    this.getDelegate().addSequenceProperty(object, object2);
                    if (object.equals("AC")) {
                        String string = object2.toString();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "; ");
                        while (stringTokenizer.hasMoreTokens()) {
                            this.accessions.add(stringTokenizer.nextToken());
                        }
                    }
                }
            }
        }
        catch (BioException bioException) {
            this.mBadFeature = true;
            System.err.println(bioException);
        }
    }

    public void endSequence() throws ParseException {
        if (this.accessions.size() > 0) {
            String string = (String)this.accessions.get(0);
            this.getDelegate().setName(string);
            this.getDelegate().setURI("urn:sequence/swissprot:" + string);
            this.getDelegate().addSequenceProperty(PROPERTY_SWISSPROT_ACCESSIONS, this.accessions);
            this.accessions = new ArrayList();
        }
        this.getDelegate().endSequence();
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;

        public Factory(SequenceBuilderFactory sequenceBuilderFactory) {
            this.delegateFactory = sequenceBuilderFactory;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new SwissprotProcessor(this.delegateFactory.makeSequenceBuilder());
        }
    }
}

