/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.RadialBaseKernel;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SimpleSVMClassifierModel;
import org.biojava.stats.svm.SparseVector;

public class SVM_Light {
    public static String firstToken(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static LabelledVector parseExample(String string) throws NumberFormatException {
        String string2 = null;
        int n = string.indexOf(35);
        if (n >= 0) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = stringTokenizer.countTokens();
        SparseVector sparseVector = new SparseVector(n2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n3 = string3.indexOf(58);
            if (n3 < 0) {
                throw new NumberFormatException("Bad dimension " + string3);
            }
            int n4 = Integer.parseInt(string3.substring(0, n3));
            double d2 = Double.parseDouble(string3.substring(n3 + 1));
            sparseVector.put(n4, d2);
        }
        return new LabelledVector(sparseVector, d, string2);
    }

    public static SVMClassifierModel readModelFile(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = SVM_Light.firstToken(bufferedReader.readLine());
        String string3 = SVM_Light.firstToken(bufferedReader.readLine());
        String string4 = SVM_Light.firstToken(bufferedReader.readLine());
        String string5 = SVM_Light.firstToken(bufferedReader.readLine());
        String string6 = SVM_Light.firstToken(bufferedReader.readLine());
        String string7 = SVM_Light.firstToken(bufferedReader.readLine());
        String string8 = bufferedReader.readLine();
        String string9 = SVM_Light.firstToken(bufferedReader.readLine());
        String string10 = SVM_Light.firstToken(bufferedReader.readLine());
        SVMKernel sVMKernel = null;
        try {
            Object object;
            Object object2;
            int n = Integer.parseInt(string9);
            switch (Integer.parseInt(string3)) {
                case 0: {
                    sVMKernel = SparseVector.kernel;
                    break;
                }
                case 1: {
                    int n2 = Integer.parseInt(string4);
                    object2 = new PolynomialKernel();
                    ((PolynomialKernel)object2).setOrder(n2);
                    ((NestedKernel)object2).setNestedKernel(SparseVector.kernel);
                    sVMKernel = object2;
                    break;
                }
                case 2: {
                    object = new RadialBaseKernel();
                    double d = Double.parseDouble(string5);
                    ((RadialBaseKernel)object).setWidth(d);
                    ((NestedKernel)object).setNestedKernel(SparseVector.kernel);
                    sVMKernel = object;
                    break;
                }
                default: {
                    throw new IOException("Couldn't create kernel");
                }
            }
            SimpleSVMClassifierModel simpleSVMClassifierModel = new SimpleSVMClassifierModel(sVMKernel);
            simpleSVMClassifierModel.setThreshold(Double.parseDouble(string10));
            while ((object2 = bufferedReader.readLine()) != null) {
                object = SVM_Light.parseExample((String)object2);
                simpleSVMClassifierModel.addItemAlpha(((LabelledVector)object).getVector(), ((LabelledVector)object).getLabel());
            }
            bufferedReader.close();
            return simpleSVMClassifierModel;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Couldn't parse model file");
        }
    }

    public static String vectorToString(SparseVector sparseVector) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 0;
        while (n < sparseVector.size()) {
            double d = sparseVector.getValueAtIndex(n);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(sparseVector.getDimAtIndex(n));
            stringBuffer.append(':');
            stringBuffer.append(d);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void writeModelFile(SVMClassifierModel sVMClassifierModel, String string) throws IOException {
        Object object;
        SVMKernel sVMKernel = sVMClassifierModel.getKernel();
        int n = 0;
        int n2 = 3;
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        String string2 = "empty";
        if (sVMKernel == SparseVector.kernel) {
            n = 0;
        } else if (sVMKernel instanceof PolynomialKernel) {
            n = 1;
            n2 = (int)((PolynomialKernel)sVMKernel).getOrder();
        } else if (sVMKernel instanceof RadialBaseKernel) {
            n = 2;
            d = ((RadialBaseKernel)sVMKernel).getWidth();
        } else {
            throw new IOException("Can't write SVM_Light file with kernel type " + sVMKernel.getClass().toString());
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        printWriter.println("SVM-light Version V3.01");
        printWriter.println(n + " # kernel type");
        printWriter.println(n2 + " # kernel parameter -d");
        printWriter.println(d + " # kernel parameter -g");
        printWriter.println(d2 + " # kernel parameter -s");
        printWriter.println(d3 + " # kernel parameter -r");
        printWriter.println(String.valueOf(string2) + " # kernel parameter -u");
        int n3 = 0;
        Iterator iterator = sVMClassifierModel.items().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (sVMClassifierModel.getAlpha(object) == 0.0) continue;
            ++n3;
        }
        printWriter.println(n3 + " # number of support vectors");
        printWriter.println(sVMClassifierModel.getThreshold() + " # threshold b");
        object = sVMClassifierModel.items().iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (sVMClassifierModel.getAlpha(e) == 0.0) continue;
            printWriter.print(sVMClassifierModel.getAlpha(object));
            SparseVector sparseVector = (SparseVector)e;
            int n4 = 0;
            while (n4 <= sparseVector.maxIndex()) {
                double d4 = sparseVector.get(n4);
                if (d4 != 0.0) {
                    printWriter.print(" " + n4 + ":" + d4);
                }
                ++n4;
            }
            printWriter.println("");
        }
        printWriter.close();
    }

    public static class LabelledVector {
        private SparseVector v;
        private double label;
        private String comment = null;

        public LabelledVector(SparseVector sparseVector, double d) {
            this.v = sparseVector;
            this.label = d;
        }

        public LabelledVector(SparseVector sparseVector, double d, String string) {
            this.v = sparseVector;
            this.label = d;
            this.comment = string;
        }

        public String getComment() {
            return this.comment;
        }

        public double getLabel() {
            return this.label;
        }

        public SparseVector getVector() {
            return this.v;
        }
    }
}

