/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.xalan.serialize.EncodingInfo;
import org.apache.xml.utils.WrappedRuntimeException;

public class Encodings {
    static final int m_defaultLastPrintable = 127;
    static final String ENCODINGS_FILE = "org/apache/xalan/serialize/Encodings.properties";
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJS = new Object[0];
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    private static final EncodingInfo[] _encodings = Encodings.loadEncodingInfo();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Thread;

    public static Writer getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        int i = 0;
        while (i < _encodings.length) {
            if (Encodings._encodings[i].name.equalsIgnoreCase(encoding)) {
                try {
                    return new OutputStreamWriter(output, Encodings._encodings[i].javaName);
                }
                catch (IllegalArgumentException iae) {
                }
                catch (UnsupportedEncodingException usee) {
                    // empty catch block
                }
            }
            ++i;
        }
        try {
            return new OutputStreamWriter(output, encoding);
        }
        catch (IllegalArgumentException iae) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public static Object getCharToByteConverter(String encoding) {
        Class<?> charToByteConverterClass = null;
        Method getConverterMethod = null;
        try {
            charToByteConverterClass = Class.forName("sun.io.CharToByteConverter");
            Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Encodings.class$("java.lang.String")) : class$java$lang$String};
            getConverterMethod = charToByteConverterClass.getMethod("getConverter", argTypes);
        }
        catch (Exception e) {
            System.err.println("Warning: Could not get charToByteConverterClass!");
            return null;
        }
        Object[] args = new Object[1];
        int i = 0;
        while (i < _encodings.length) {
            if (Encodings._encodings[i].name.equalsIgnoreCase(encoding)) {
                try {
                    args[0] = Encodings._encodings[i].javaName;
                    Object converter = getConverterMethod.invoke(null, args);
                    if (null != converter) {
                        return converter;
                    }
                }
                catch (Exception iae) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    public static int getLastPrintable(String encoding) {
        int i = 0;
        while (i < _encodings.length) {
            if (Encodings._encodings[i].name.equalsIgnoreCase(encoding) || Encodings._encodings[i].javaName.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i].lastPrintable;
            }
            ++i;
        }
        return 127;
    }

    public static int getLastPrintable() {
        return 127;
    }

    public static String getMimeEncoding(String encoding) {
        block5: {
            if (null == encoding) {
                try {
                    encoding = System.getProperty("file.encoding", "UTF8");
                    if (null != encoding) {
                        String jencoding = encoding.equalsIgnoreCase("Cp1252") || encoding.equalsIgnoreCase("ISO8859_1") || encoding.equalsIgnoreCase("8859_1") || encoding.equalsIgnoreCase("UTF8") ? DEFAULT_MIME_ENCODING : Encodings.convertJava2MimeEncoding(encoding);
                        encoding = null != jencoding ? jencoding : DEFAULT_MIME_ENCODING;
                        break block5;
                    }
                    encoding = DEFAULT_MIME_ENCODING;
                }
                catch (SecurityException se) {
                    encoding = DEFAULT_MIME_ENCODING;
                }
            } else {
                encoding = Encodings.convertJava2MimeEncoding(encoding);
            }
        }
        return encoding;
    }

    public static String convertJava2MimeEncoding(String encoding) {
        int i = 0;
        while (i < _encodings.length) {
            if (Encodings._encodings[i].javaName.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i].name;
            }
            ++i;
        }
        return encoding;
    }

    public static String convertMime2JavaEncoding(String encoding) {
        int i = 0;
        while (i < _encodings.length) {
            if (Encodings._encodings[i].name.equalsIgnoreCase(encoding)) {
                return Encodings._encodings[i].javaName;
            }
            ++i;
        }
        return encoding;
    }

    private static EncodingInfo[] loadEncodingInfo() {
        URL url = null;
        try {
            String urlString = null;
            try {
                urlString = System.getProperty("org.apache.xalan.serialize.encodings", "");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (urlString != null && urlString.length() > 0) {
                url = new URL(urlString);
            }
            if (url == null) {
                ClassLoader cl = null;
                try {
                    Method getCCL = (class$java$lang$Thread == null ? (class$java$lang$Thread = Encodings.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", NO_CLASSES);
                    if (getCCL != null) {
                        cl = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), NO_OBJS);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (cl != null) {
                    url = cl.getResource(ENCODINGS_FILE);
                }
            }
            if (url == null) {
                url = ClassLoader.getSystemResource(ENCODINGS_FILE);
            }
            Properties props = new Properties();
            if (url != null) {
                InputStream is = url.openStream();
                props.load(is);
                is.close();
            }
            int totalEntries = ((Hashtable)props).size();
            EncodingInfo[] ret = new EncodingInfo[totalEntries];
            Enumeration keys = ((Hashtable)props).keys();
            int i = 0;
            while (i < totalEntries) {
                int lastPrintable;
                String mimeName;
                String javaName = (String)keys.nextElement();
                String val = props.getProperty(javaName);
                int pos = val.indexOf(32);
                if (pos < 0) {
                    mimeName = val;
                    lastPrintable = 255;
                } else {
                    mimeName = val.substring(0, pos);
                    lastPrintable = Integer.decode(val.substring(pos).trim());
                }
                ret[i] = new EncodingInfo(mimeName, javaName, lastPrintable);
                ++i;
            }
            return ret;
        }
        catch (MalformedURLException mue) {
            throw new WrappedRuntimeException(mue);
        }
        catch (IOException ioe) {
            throw new WrappedRuntimeException(ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

