#include <stdio.h>   /* the standard io stuff */
#include <math.h>                         

#include "notestructs.c"
#include "trialsave.c"
#include <X/Xlib.h>
#include <signal.h>
#include <sys/time.h>


Window windowid;

/************************
*  Event data
*
*	This union is needed to get at the details of an event.  
*	The fact that the Xevent structure and the particular
*	event description structures occupy the same memory is
*	not described in the Xlib documentation.  The detail fields
*	of an event are accessed through this union as   
*			event.keypress.detail  
*	etc.   One other point; the input calls, XNextEvent, etc. need
*	a pointer, therefore the address of the union is passed.
*/
union evnt { XEvent                rep;
	     XKeyPressedEvent      keypress;
	     XButtonPressedEvent   buttpress;
	     XButtonReleasedEvent  buttrelease;
	     XEnterWindowEvent	   enterwin;
	     XLeaveWindowEvent	   exitwin;
	     XMouseMovedEvent      mousemove;
          } event;


Font f;

int timer();
int tries = 0;



/********************************************************************
* MAIN
*
* 
*
*/
main()
{

int count = 0;
int d,x,y;
int len;
int nbytes;
char msg[30];  /* my local storage buf */
char msg2[30]; 
char *c;  /* pointer to static mem */

struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;
int j = 0;
int t;
int update_status,
    point_x,
    point_y;   /* inputs from keyboard or touch screen  */

    char *name[80];
  char *buffer = calloc( 1, 100 * sizeof(char) );
  int  size = 100;









/*********************
* Initialize the timer 
*/

timvl.it_value.tv_sec = 1;
timvl.it_value.tv_usec = 0;
timvl.it_interval.tv_sec = 1;
timvl.it_interval.tv_usec = 0;




/*********************
*   Open the X display
*       For some reason, the signal alarm sent the thing back through
*       these parts on the first interrupt.  `Tries' is a fix to keep
*	it from trying to reinitialize the windows.
*/

if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1);
   }




/**********************
*  Create a root window
*/
if(tries == 1){  
  windowid = XCreateWindow(RootWindow,
			 50,
			 50,
			 400,
			 200,
			 3,
			 BlackPixmap,
			 WhitePixmap);


  XMapWindow(windowid);



/***********************
*  Select inputs to root
*/

  XSelectInput(windowid, ButtonPressed 
	               | ButtonReleased 
	               | KeyPressed
	               | MouseMoved
	               | EnterWindow
	               | LeaveWindow);




/**********************
*  Set up the font.
*/

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }




/********************************
*  Init commands
*/

init_commands(); /*make address assignments for commands */




/*******************************
*  Load in system notes
*/

label[0]=calloc(1,sizeof(struct label));
sprintf(label[0]->buffer, "sysnotes.dat");
param[0]=calloc(1, sizeof(struct param));
param[0]->type = LABEL;
param[0]->content = 0;
load_notes(0);
sysnotes = count->notes;




/***************************
*  Start the timer interrupt.
*/

  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();





}  /* this marks the end of the init stuff, protected by `tries' */






/************************************************************************
*   MAIN CONTROL loop starts here.
*
*    What this thing does is wait for an event from the user.  It 
*    finds out what kind of event it's got, then calls a jobber to
*    take care of it.
*/

while(1){



/********************************************
*  Get next event;  blocks if queue is empty.
*/

  XNextEvent(&event.rep);

  switch (event.rep.type){
	case  ButtonPressed:
		d = event.buttpress.detail;

		break;

	case  ButtonReleased:
		d = event.buttrelease.detail;

		break;

	case  KeyPressed:
		d = event.keypress.detail;
	        c = XLookupMapping(&event.keypress, &nbytes);
		strncpy(msg2, c, nbytes);
		len = nbytes;

		break;

	case  EnterWindow:
		break;

	case  LeaveWindow:
		break;

	case  MouseMoved:
		x = event.mousemove.x;
		y = event.mousemove.y;
		
		break;
   }

   XFlush();

  
 }

}/***********   END MAIN  **************************/



/************************************************************************
*   TIMER CONTROL LOOP
*      	This one fires up on every alarm.  Goes through the list of 
*	timed events, then goes back to sleep.
*/
int 
timer()
{
  static int count;
  char *msg[30];
  int len;

  ++count;
  sprintf(msg,"Timer%d",count);
  len = strlen(msg);

  XText(windowid,
	100,10,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
}









/***************************************************************************
*  POINTER
*
*/
pointer()
{
          
   static int   from_x,
        	from_y,
                show_x,
        	show_y,
        	lopmode;
     
     
     
   struct ele *list;
     
   int  node,
    	mode,
    	level,
	n,
    	i,
	j,
    	x,
   	y,
    	a,
    	b;
     
   float fx,
     	 fy;
     
     
     


     
   /* normalize to the pixel count 
   posn->sx = (pdi.xpos * 959) / 4096.0;
   posn->sy = (pdi.ypos * 599) / (4096 * .625);
   */



   t_syspace(posn);  
   if( (n=find_active_note(posn)) > 1){
	current->note = n;
	current->pos = posn;
         if(making_dobs && n > sysnotes) make(current->dob, dobend, posn);
	 else do_commands(n);  
       }

   else{
         if(making_dobs) make(current->dob, dobend, posn);
         else{ 
	       /*	t_w(posn);  */
   	       	if( (n=find_active_note(posn)) != 0) do_commands(n);
	      }                                   
	}

     

 }                             





/************************************************************************
*  KYBD
*/
kybd(input_buffer)
 char *input_buffer[100];
{
    int d,n;
    union buffer { char *txt[100];
		   int c[100];} bf;
    union buffer *in = &bf;

    strcpy(in->txt, input_buffer);

    if(making_dobs || getting_params){
        d = current->dob;

	switch(dob[d]->type){
	  case TEXT:
    	      if((n = ++count->texts) > MAXTEXTS)
		    return;  /* error msg - Exceeds text object quota.*/
	      text[n] = calloc(1, sizeof(struct text));
	      strcpy(text[n]->buffer,in->txt);
              dob[d]->type = TEXT;
	      dob[d]->text = n;
	      dob[d]->tail = DEFINED;
	      input_string(d);
		break;

	  case LABEL:	      
    	      if((n = ++count->labels) > MAXLABELS)
		    return; /* error msg - Exceeds label object quota*/
	      label[n] = calloc(1, sizeof(struct label));
	      strcpy(label[n]->buffer,in->txt);
              dob[d]->type = LABEL;
	      dob[d]->label = n;
	      dob[d]->tail = DEFINED;
	      input_string(d);
   	      break;
  	 } /* end switch -- non-text dobs fall through */

     }


    switch(in->c[0]){
	  case 'e':  /*  Exit  */
    		return(0);
                break;

	}



    if (in->c[0]== '\033'){       /*  check 1st character for ESCAPE  */
	switch (in->c[2])  {    /*  then switch on third character  */
	  case 'A':           /*    uparrow                     */

		break;
	  case 'B':           /*    downarrow			*/

		break;
	  case 'D':           /*    left arrow 			*/

	     	break;                                          
	  case 'C':           /*    right arrow 		*/

		break;
	  case 'q':	      /*  keypad 1  */

		break;
	  case 'r':	      /*  keypad 2  */

		break;
	  case 's':	      /*  keypad 3  */

		break;
                                                      
        } /* end escape character switch*/
      } /* if */


}


		
/************************************************************************
*   MAKE
*/
make(d,dobend,pos)
  int d;
  int dobend;
  struct pos *pos;
{

  switch(dob[d]->type){
     case RECTANGLE:
     case LINE:
     case TEXT:
     case LABEL:
	duple(d,dobend,pos);
	break;

    }
}

/************************************************************************
*   T_SYSPACE
*/
t_syspace(pos)
  struct pos *pos;
{

  pos->wx = (pos->sx / SCRX) * SPCX;
  pos->wy = (pos->sy / SCRY) * SPCY;

}
/************************************************************************
*   SYSPACE_T
*/
syspace_t(pos)
  struct pos *pos;
{

  pos->sx = (pos->wx / SPCX) * SCRX;
  pos->sy = (pos->wy / SPCY) * SCRY;

}
   


       




/************************************************************************
*   CREATE NOTE (If parent = -1 it's not a parent.  It's put in as NEXT
*						    by the caller.)
*/
create_note(parent,notecount)
 int parent,notecount;
{
struct note *new;
if (++notecount < MAXNOTES){
  new = calloc(1, sizeof(struct note));
  new->active = YES;
  new->parent = parent;
  note[notecount] = new;
  return(notecount);  /* send this note's number back to parent */
 }

}


/************************************************************************
*  DELETE NOTE
*/
delete_note(x)
   int x;
{
if(note[x]->active = YES) deactivate_note(x);
note[x]->deleted = YES;
notes_modified = YES;
}





/************************************************************************
*  ACTIVATE NOTE
*/


activate_note(x)
  int x;
{

struct active *new;

if(note[x]->deleted == NO && note[x]->active == NO){

  note[x]->active = YES;

  new = calloc(1, sizeof(struct active));
  new->note = x;
  new->next = active_notes;
  if (active_notes != 0) active_notes->prev = new;
  active_notes = new;

  if (note[x]->zone!= 0) display_dob( note[x]->zone);
                     
  if (note[x]->children != 0) activate_note( note[x]->children);
  if (note[x]->next != 0) activate_note( note[x]->next);
 }
}



                   

/************************************************************************
*  ERASE AND DEACTIVATE NOTE
*/
erase_and_deactivate(x)
  int x;
{
if(note[x]->deleted == NO  && note[x]->active == YES){
  if (note[x]->zone != 0) erase_dob(note[x]->zone,current);
  deactivate_note(x);
 }
}






/************************************************************************
*  DEACTIVATE NOTE
*/
deactivate_note(x)
  int x;
{
  struct active *tmp;

  if(note[x]->deleted == NO  && note[x]->active == YES){

    note[x]->active = NO;
        
    tmp = active_notes;
    if(tmp == 0) return(0);  /* first make sure the well isn't dry. */
    
    while(tmp != 0){  /* next find the right one to get rid of */
      if(tmp->note == x) break;
      else tmp = tmp->next;
     }

    if(tmp->next == 0){ /* if it's the last on the list */
      if(tmp->prev == 0) { /* and if it's the first one on list */
        active_notes = 0;  /* then delete the list */
       }
      else{ /* else if it's last but not the first */
        tmp->prev->next = 0;  /* clip it off the end */
       }    
     }
    else{  /* if it's not the last on the list */
      if(tmp->prev == 0){ /* but is the first on the list */
        active_notes = tmp->next; /* clip it off the front */
        active_notes->prev = 0;  /* and remove backward pointer */
       }
      else{ /* it's somewhere in the middle of the list */
        tmp->prev->next = tmp->next;  /* so clip it out */
        tmp->next->prev = tmp->prev;
       }
     }
    cfree(tmp);

    if (note[x]->children != 0) deactivate_note( note[x]->children);
    if (note[x]->next != 0) deactivate_note( note[x]->next);
   }
}






/************************************************************************
*  FIND PARENT DOB
*/
find_parent_dob(p, pos)
  int p;  /* parent note */
  struct pos *pos;
{
int pd; /* parent dob */

return(pd = find_dob(note[p]->zone, pos));

}






/************************************************************************
*   FIND NOTE (to find the lowest note at x,y)
*/
find_note(n,pos)
  int n; /* starting from note n */
  struct pos *pos;
{

float wx = pos->wx;                          
float wy = pos->wy;
int lowest;

while( note[n] != 0){

   if( note[n]->active == YES  &&  note[n]->zone != 0 ){
              
    if(wx >= dob[note[n]->zone]->x && wx <= dob[note[n]->zone]->x+dob[note[n]->z
one]->xdim
       && wy >= dob[note[n]->zone]->y && wy <= dob[note[n]->zone]->y + dob[note[
n]->zone]->ydim){


	    if( (lowest = find_note(note[n]->children,pos)) != 0)
	      	    return(lowest);
	    else    return(n);
          
        
     }
    }
   n = note[n]->next;
 }

 return(1); /* sends back 0 if top level */
}



/************************************************************************
*   FIND ACTIVE NOTE (to find the lowest note at x,y on the ACTIVE list)
*/
find_active_note(pos)
  struct pos *pos;
{

float wx = pos->wx;                          
float wy = pos->wy;
struct active *tmp;
int n, lowest;

tmp = active_notes;
if (tmp == 0) return(0);
                        
while( tmp != 0){

   n = tmp->note;
   if( note[n]->active == YES  &&  note[n]->zone != 0 ){
              
    if( wx >= dob[note[n]->zone]->x && wx <= dob[note[n]->zone]->x+dob[note[n]->
zone]->xdim
       && wy >= dob[note[n]->zone]->y && wy <= dob[note[n]->zone]->y + dob[note[
n]->zone]->ydim){

	    if( (lowest = find_note(note[n]->children,pos)) != 0)
	      	    return(lowest);
	    else    return(n);

     }
    }
   tmp = tmp->next;                                              
 }

 return(1); /* sends back 0 if top level */
}




                               
/************************************************************************
*   FIND DOB(to find the lowest dob at x,y within a given note n)
*/                             
find_dob(n,pos)
  int n;  /* starting dob number */
  struct pos *pos;
{

float wx = pos->wx;              
float wy = pos->wy;
int lowest;
                                   
while( dob[n]->next != 0){

    if(   wx >= dob[n]->x && wx <= dob[n]->x + dob[n]->xdim
       && wy >= dob[n]->y && wy <= dob[n]->y + dob[n]->ydim){

	    if( (lowest = find_dob(dob[n]->children,pos)) != 0)
	      	    return(lowest);
	    else    return(n);

        
     }
   n = dob[n]->next;
 }

 return(1);
}





           


/************************************************************************
*  DISPLAY DOB
*/
display_dob(d)
  int d;
{

  int revisions,t;
  float oldx = current->x;
  float oldy = current->y;
  struct pos posn;
  struct pos *pos = &posn;
  float xp,yp,dx,dy;


  pos->wx = current->x + dob[d]->x;
  pos->wy = current->y + dob[d]->y;
  syspace_t(pos);
  xp = pos->sx; 
  yp = pos->sy;
  pos->wx = dob[d]->xdim;
  pos->wy = dob[d]->ydim;
  syspace_t(pos);
  dx = pos->sx;
  dy = pos->sy;

if(dob[d]->color != INVISIBLE){
                         
  if((revisions = dob[d]->attributes ^ current->attributes)!=0){ /* -> not ready
 */
     set_attribs(revisions,current);
  }

  if(dob[d]->color != current->color){
    CGL_COLOR(dob[d]->color);
    current->color = dob[d]->color;
   }

  switch(dob[d]->type){       
                      
	case TEXT:
                CGL_MOVE(xp,yp);
		t = dob[d]->text;
		CGL_PRINT(text[t]->buffer);
		break;
  
	case LABEL:
		CGL_MOVE(xp,yp);
		t = dob[d]->label;
		CGL_PRINT(label[t]->buffer);
		break;

	case BOX:
                CGL_MOVE(xp,yp);
		CGL_BOX_REL(dx,dy);
		break;

	case LINE:
                CGL_MOVE(xp,yp);
		CGL_LINE(dx,dy);
		break;
 
       }

 }

  if (dob[d]->children != 0){
     current->x = xp;
     current->y = yp;
     display_dob(dob[d]->children);
     current->x = oldx;
     current->y = oldy;
    }
  if (dob[d]->next != 0) display_dob(dob[d]->next);

}




/**********************************************************************
*  SET ATTRIBUTES
*/
set_attribs(mask,current)
  int mask;
  struct state *current;
{
  int a = current->attributes;
  int b,c,d;

/* FILL v. NOFILL */

  if( mask & FILLBIT){
    if( a & FILL){
	CGL_NOFILL;
        a = a ^ FILL;
      }
    else{
	CGL_FILL;
	a = a | FILL;
      }
   }


/* CLEAR v. OVERLAY v. COMPLEMENT*/

  if( mask & MODEBITS){

    b = MODEBITS & mask;  /* isolate the 3 bits, 2 of which are set */
    c = a & b;  /* gets which bit is currently set */
    c = c ^ b;   /* get which one needs to be set */
    a = a & (d = MODEBITS ^ -1);  /* clear out the bit currently set*/
    a = a | c;  /* set the new bit */
    switch(c){
	case CLEAR:
	   CGL_WRCLEAR;
	   break;
	case OVERLAY:
	   CGL_WROVER;
	   break;
	case COMPLEMENT:
	   CGL_WRCOMPLEMENT;
	   break;
       }
   }



current->attributes = a;
}





/**********************************************************************
*  ERASE DOB
*/
erase_dob(d,current)            
  int d;
  struct state *current;
{
  int t;
  struct pos posn;
  struct pos *pos = &posn;
  float xp,yp,dx,dy;


  pos->wx = current->x + dob[d]->x;
  pos->wy = current->y + dob[d]->y;
  syspace_t(pos);
  xp = pos->sx;
  yp = pos->sy;
  pos->wx = dob[d]->xdim;
  pos->wy = dob[d]->ydim;
  syspace_t(pos);
  dx = pos->sx;
  dy = pos->sy;

  set_attribs(CLEAR,current);

  CGL_WRCLEAR;

  switch(dob[d]->type){

	case TEXT:
                CGL_MOVE(xp,yp);
		t = dob[d]->text;
		CGL_PRINT(text[t]->buffer);
		break;
  
	case LABEL:
		CGL_MOVE(xp,yp);
		t = dob[d]->label;
		CGL_PRINT(label[t]->buffer);
                break;

	case BOX:
                CGL_MOVE(xp,yp);
		CGL_BOX_REL(dx,dy);
		break;

	case LINE:
                CGL_MOVE(xp,yp);
		CGL_LINE(dx,dy);
		break;
 
       }


}






/************************************************************************
*  DUPLE
*/
duple(d,dobend,pos)
  int d;  /* dob number */
  int dobend;
  struct pos *pos;
{

  int n,i,j,p,pd,v;
  int new_parent = NO;

  switch(dobend){
     case HEAD:

	/*  First find out whether there is a change in the linkage 
	*   due to the new head position.
	*/

	p = find_note(1,pos); /* get new parent note (1 if toplevel) */
	pd = find_parent_dob(p, pos); /* 1 if toplevel */


	if(dob[d]->head == DEFINED){ 

	     if(dob[d]->zone == YES){ /* if this dob is a zone */

	       if(p != dob[d]->parent){ /* parent NOTE is different */
		  delete_note(p); /* since this dob is its zone */
		  new_parent = YES;
		 }
	      }
	     else{ /* part of a display list */		

	       if(pd != dob[d]->parent){
                  dob[dob[d]->prev]->next = dob[d]->next; /* decouple old parent
*/
		  dob[dob[d]->next]->prev = dob[d]->prev;
		}
	      }                     

         }
	else{ 
	      dob[d]->head = DEFINED;
              new_parent = YES;
	 }

  /*   Next, if the dob is being moved, erase the old copy.
  */
	if(dob[d]->head == DEFINED  && dob[d]->tail == DEFINED){
	   erase_dob(d,current);
         }

             



        if(new_parent){ /* either head wasn't defined or has changed */

          if(making_zone){  
		note[current->note]->parent = p;
		note[current->note]->next = note[p]->children;
                note[p]->children = current->note;

		dob[d]->zone = YES; /* note that this one's a zone*/
		dob[d]->next = note[current->note]->zone;
		dob[d]->parent = current->note;
		note[current->note]->zone = d; /* dob number for zone */
	
           }
                                        


          else{
  	         dob[d]->parent = pd;
		 dob[d]->next = dob[pd]->children;
		 dob[pd]->children = d;
	        }


        }
                     




        if(dob[d]->zone == YES){  
	     v = note[p]->zone;
	     dob[d]->x = pos->wx - dob[v]->x;
	     dob[d]->y = pos->wy - dob[v]->y;

         }
	else{
	     v = dob[d]->parent;
	     dob[d]->x = pos->wx - dob[v]->wx;
	     dob[d]->y = pos->wy - dob[v]->wy;

	 }


	dob[d]->wx = pos->wx;
	dob[d]->wy = pos->wy;


        if(dob[d]->tail == DEFINED){
                /* add a check in here for a tail that's out of bounds on
		* account of a change in linkage.*/

	  	display_dob(d);
	 }
	else CGL_MOVE(pos->sx, pos->sy);	  

/*  Last, a special req. for text objects, set the maximum xdim to
*   the leftmost bound of the dob parent.
*/	

	if(dob[d]->type == TEXT || dob[d]->type == LABEL){
         dob[d]->xdim = dob[pd]->xdim - dob[d]->x;
	 dob[d]->ydim = dob[pd]->ydim - dob[d]->y;
	}


        break;
                                  

		

	

     case TAIL:                                   

        if(dob[d]->tail == DEFINED) erase_dob(d,current);
	else dob[d]->tail = DEFINED;

	

	dob[d]->xdim = abs((i=dob[d]->wx)-(j=pos->wx));
	dob[d]->ydim = abs((i=dob[d]->wy)-(j=pos->wy));
	display_dob(d);

	break;
  }


}






/********************************************************************
*  NEW DOB
*/
new_dob(type)
  int type; /* RECTANGLE,LINE,CIRCLE,TEXT,LABEL,etc.*/
{
  int d, n;

  if((d= ++count->dobs) > MAXDOBS) return(0); /* returns 0 on failure */
  if(making_zone == YES){
    if((n= ++count->notes) > MAXNOTES) return(0); /* returns 0 on failure */
    note[n] = calloc(1, sizeof(struct note));
    activate_note(n);
   }

  dobend = HEAD;
  dob[d] = calloc(1, sizeof(struct dob));
  dob[d]->type = type;
  dob[d]->color = current->color;
  dob[d]->attributes = current->attributes;
  dob[d]->deleted = NO;


  if(making_zone == YES){
    note[n]->zone = d;
    dob[d]->parent = n;
    current->note = n;
   }
  
  current->dob = d;

  making_dobs = YES;
}

/********************************************************************
*  RECTANGLE
*/
frectangle()
{
  new_dob(RECTANGLE); 
}
/********************************************************************
*  CIRCLE
*/
fcircle()
{
  new_dob(CIRCLE);
}
/********************************************************************
*  POLYGON
*/
fpolygon()
{
  new_dob(POLYGON);
}
/********************************************************************
*  LINE
*/
fline()
{
  new_dob(LINE);
}
/********************************************************************
*  TEXT
*/
ftext()
{
  input_string(TEXT);
}
/********************************************************************
*  LABEL
*/
flabel()
{
  new_dob(LABEL);
}
/********************************************************************
*  ZONE_NOZONE
*/
zone_nozone()
{
  if(making_zone == YES) making_zone = NO;
  else making_zone = YES;
}
/********************************************************************
*  FILL_NOFILL
*/
fill_nofill()
{
  int mask = FILLBIT;  /* set attribs will toggle fill */
  set_attribs(mask, current);
}
/********************************************************************
*  CTRL PT
*/
ctrl_pt()
{
 if(dobend == HEAD) dobend = TAIL;
 else dobend = HEAD;
}
/********************************************************************
*  SETCOL
*/
setcol(c)
 int c;
{
CGL_COLOR(c);
current->color = c;
}



                                   
/******************************************************************
*  DO COMMAND LIST
*/
do_commands(n)
   int n;
{
   int c = note[n]->comlist;
   int f,p;

   while( c != 0 ){  /* a no-commands note bumps out right here*/

      f = command[c]->function;
      if((p = command[c]->params) != 0){
	switch(param[p]->type){
	   case INT:
	      (*function[f])(param[p]->content);
	      break;
	   case FLOAT:
	      (*function[f])(param[p]->fcon);
	      break;
	   case TEXT:
	      (*function[f])(text[param[p]->content]->buffer);
	      break;
	   case LABEL:
	      (*function[f])(label[param[p]->content]->buffer);
	      break;
         }
        }
      else (*function[f])();
      c = command[c]->next;
    }
}

/******************************************************************
*  INIT COMMANDS
*/
init_commands()
{
   function[LOAD_NOTES]		= &load_notes;
   function[SAVE_NOTES]		= &save_notes;
   function[ACTIVATE_NOTE] 	= &activate_note;
   function[ER_DEAC_NOTE]	= &erase_and_deactivate;
   function[DEACTIVATE_NOTE]	= &deactivate_note;
   function[SET_ATTRIBS]	= &set_attribs;
   function[FRECTANGLE]		= &frectangle;
   function[FCIRCLE]		= &fcircle;
   function[FPOLYGON]		= &fpolygon;
   function[FLINE]		= &fline;
   function[FTEXT]		= &ftext;
   function[FLABEL]		= &flabel;
   function[ZONE_NOZONE]	= &zone_nozone;
   function[FILL_NOFILL]        = &fill_nofill;
   function[CTRL_PT]		= &ctrl_pt;
   function[SETCOL]		= &setcol;
}                                         



/*******************************************************************
*  INPUT STRING
*/
input_string(d)
  int d;
{
  char *c;
  int j = 1;
  float txtw,txth;
  float oldx = current->x;
  float oldy = current->y;
  struct pos posn;
  struct pos *pos = &posn;
  float xp,yp,dx,dy;
  int n, x, maxex;
  int type = dob[d]->type;
  int a = current->attributes;


  pos->wx = current->x + dob[d]->x;
  pos->wy = current->y + dob[d]->y;
  syspace_t(pos);
  xp = pos->sx; 
  yp = pos->sy;
  pos->wx = dob[d]->xdim;
  pos->wy = dob[d]->ydim;
  syspace_t(pos);
  dx = pos->sx;
  dy = pos->sy;
  maxex = xp + dx;
  
  CGL_GET_CHARSIZE(txtw,txth);

  if(!((dob[d]->x+dob[d]->xdim > txtw) && (dob[d]->y+dob[d]->ydim > txth)))
       return; /* error msg - No space for intended text */

  CGL_MOVE(xp,yp);

  set_attribs(COMPLEMENT,current);

  CGL_CURSOR;

  switch(type){

  case LABEL:
    
    n = dob[d]->label;
    CGL_PRINTAT(xp,yp,label[n]->buffer);
    xp = xp + txtw;              

    c = get_keyin();
    while(    c[0] != RETURNCHAR 
	   && xp < maxex
           && (++j < LABELSIZE) ){

      if(c[0] == DELETECHAR){
        if(j != 0){
	  c[0] = label[n]->buffer[--j];  
	  c[1] = 0;
          --j;
	  xp = xp - txtw;
	  CGL_PRINTAT(xp,yp,c);
         }
       }
      else{
	label[n]->buffer[j] = c[0];
	CGL_PRINTAT(xp,yp,c);
	xp = xp + txtw;
         
      }

     c = get_keyin();	
     }

    dob[d]->xdim = j * txtw;
    dob[d]->ydim = txth;

    break;


  case TEXT:

    break;

  }

  set_attribs(a,current);

}

/**********************************************************************
*  INPUT PARAMETER
*/
input_param(t,d,p)
 int t,d,p;  /* type, dob number, param number */
{

  current->dob = d;
  current->context = INPUT_PARAM;


   
}

/**********************************************************************/
get_keyin()
  {
  /* do a qiow to read a single stroke from the keyboard */
  init_input( input_ptr, iosb_ptr, block_ptr );
  
  /* return the pointer to the buffer containing the char(s) */
  return( block_ptr->buffer );
  }

