
@device {postscript}
@make {Article,Form 1}
@style {Spacing 1.1}
@style {FontFamily TimesRoman, FontScale 12}
@style {RightMargin 1.75inches}
@style {LeftMargin 1.75inches}
@style {TopMargin 2in, BottomMargin 1.875in}
@style {Indent 5 characters}
@modify{Heading, FlushLeft}





@heading{Overview}

Grammar:

  display  -> name
	   -> screen ->
	   -> element ->
	   -> dimension ->
	   -> active
	   -> next

  screen   -> name
	   -> type
	   -> next
	   
  element  -> name
	   -> active
	   -> type
	   -> map ->
	   -> filename
	   -> next
	   
  map 	   -> in_point
	   -> out_point
	   -> icon
	   -> label

  dimension  -> name
	     -> max
	     -> min
	     -> range
	     -> boundary







Rules:


Name is mandatory; all other parameters are optional.

Order of parameters is irrelevant.

Active needs no value, just put the word active in.  If the word active is
there, then the display or element will be active.


    "package", 1,
    "element", 2,
    "screenset", 3,
    "screen", 4,
    "map", 5,
    "dimension", 6,
    "include", 7,
    "name", 8,
    "next", 9,
    "type", 10,
    "active", 11,
    "label", 12,
    "in", 13,
    "out", 14,
    "icon", 15,
    "filename", 16,
    "pos_in", 17,
    "pos_out", 18,
    "max", 19,
    "min", 20,
    "range", 21,
    "boundary", 22,
    "screen_name", 23,
    "parent", 24,
    "xpos", 25,
    "ypos", 26,
    "width", 27,
    "height", 28,
    "borderwidth", 29,
    "border", 30,
    "background", 31,
    "key_dimension", 32





Screen Types

    "video", 1,
    "still", 2,
    "text", 3,
    "tk_widget", 4,
    "window", 5,
    "transparency", 6



Display function types

These are used in 

    "video", (char *) display_video,
    "still", (char *) display_still,
    "text", (char *) display_text,
    "tk_widget", (char *) display_TKwidget



Boundary types

These declare what happens when a dimension goes out of bounds.  They
are valid field values for the @i{boundary} keyword in the dimension
declaration.

    "wrap",1,
    "freeze", 2,
    "bounce", 3,
    "limit", 4


Active types

    "yes", 1,
    "no", 0,


Map types

Values that can follow the @i{type:} keyword in a map declaration:

    "still", 0,
    "video", 1,
    "complex", 2,
    "line", 3,
    "button", 4,
    "tkdialog", 5,
    "tkscroll", 6,
    "tktext", 7


Callback Functions

These are the names that can be placed after the @i{function} keyword
in the map declaration.  They are valid for maps of tool kit widgets
(tkbutton, tkscroll, and tkdialog).

    "IntFunction", (char *) IntFunction, INT_PARAM,
    "StringFunction", (char *) StringFunction, STRING_PARAM,
    "video", (char *) video, STRING_PARAM,
    "scroll", (char *) scroll, NULL,
    "thumb", (char *) thumb, NULL,
    "set_position", (char *) set_position, PACKPOS_PARAM,
    "rset_position", (char *) rset_position, PACKPOS_PARAM



Tool Kit Widget Parameters

Legal keywords for all tool kit widgets.

    "window", 1,
    "label", 2, 
    "font", 3,
    "borderwidth", 4,
    "foreground", 5,
    "background", 6,
    "border", 7,
    "width", 8,
    "height", 9,
    "justify", 10,
    "function", 11,
    "parameter", 12,
    "highlight", 13,
    "unhighlight", 14,
    "notify", 15,
    "orientation", 16,
    "thumb", 17,
    "scrollupdownproc", 18,
    "thumbproc", 19,
    "top", 20,
    "shown", 21,
    "hspace", 22,
    "vspace", 23,
    "dialogvalue", 24,
    "dialogbutton", 25,
    "name", 26,
    "x", 27,
    "y", 28,
    "value", 29,
    "pos_in", 30,
    "pos_out",31,
    "edit_type", 32,
    "text_options",    	33,
    "display_position", 34,
    "insert_position",	35,
    "left_margin",		36,
    "file",			37,
    "string",		38,
    "length",		39,
    "event_bindings",	40,
    "entry",		41




@heading{Tool Kit Widgets}

@subheading{Command Button}


button
name		string
label		string
font		string
borderwidth	int
foreground	int
background	int
justify		int
function	string -- see list of valid functions above
parameter	int or string
width		int
height		int
x		int
y		int


Example:
	element
	name: phantoms
	type: tk_widget
	active
	screen_name: bigblue

	map
	type: button
	pos_in: 4,0,0,0,0
	pos_out: 8,0,0,0,0 
	label: End
	x: 300
	y: 800
	font: helv10b
	border: 5
	width: 10
	height: 10
	background: 0
	foreground: 1
	name: command
	function: set_position
	parameter: tides,1,0,0,0,0



@subheading{Scrollbar}

name		string
window		string
orientation	string
x		int
y		int
width		int
height		int
borderwidth	int
foreground	int
background	int
border		int
scrollproc	string (function list)
thumbproc	string (function list)
value		int or string
top		float
shown		float

Example:

	map
	type: tkscroll
	pos_in: 1, 2, 3, 4,5
	pos_out: 9,8,7,6,5
	x: 200
	y: 800
	width: 500
	height: 20
	background: 1
	foreground: 0
	scrollupdownproc: scroll
	thumbproc: thumb
	name: command
	top: 25
	shown: 2


@subheading{Text}

name		string
parent		string
x		int
y		int
width		int
height		int
borderwidth	int
foreground	int
background	int
border		int
file		string
string		string
length		int
font		string
entry		???
event_bindings	string
edit_type		string *don't try it yet*
text_options		int
left_margin		int
display_position	int
insert_position		int

typedef struct _TKtext{
	  int 		 selected;
	  Window 	 w, parent;
	  int 		 x, y, width, height,length,borderwidth;
	  int 		 foreground, background, border;
	  Pixmap 	 foreground_pixmap, background_pixmap, border_pixmap;
	  char 		 name[Nchars], parentname[Nchars];
	  char		 file[Nchars], string[Nchars], event_bindings[Nchars];
 	  int		 options;
	  int 		 display_pos, insert_pos, left_margin;  
	  FontInfo	 *font;
	  XtEditType     edit_type;
	} TKtext;


static Arg TKtextarglist[] = {
  	{XtNname,		(caddr_t) "text"},
	{XtNeditType,		(caddr_t) XttextRead},
	{XtNtextOptions, 	(caddr_t) NULL},
	{XtNdisplayPosition, 	(caddr_t) 0},
	{XtNinsertPosition, 	(caddr_t) 0},
	{XtNleftMargin, 	(caddr_t) 2},
	{XtNforeground, 	(caddr_t) NULL},
	{XtNbackground, 	(caddr_t) NULL},
	{XtNborder, 		(caddr_t) NULL},
	{XtNborderWidth, 	(caddr_t) 4},
	{XtNfile, 		(caddr_t) NULL},
	{XtNstring, 		(caddr_t) NULL},
	{XtNlength, 		(caddr_t) 200},
	{XtNfont, 		(caddr_t) NULL},
	{XtNeventBindings, 	(caddr_t) NULL},
	{XtNwidth, 		(caddr_t) 100},
	{XtNheight, 		(caddr_t) 20}
	};


#define XtkTextName		0
#define XtkTextWindow           1
#define XtkTextEditType         2
#define XtkTextOptions		3	
#define XtkTextDisplayPosition	4
#define XtkTextInsertPosition	5
#define XtkTextLeftMargin	6
#define XtkTextForeground	7
#define XtkTextBackground	8
#define XtkTextBorder		9
#define XtkTextBorderWidth	10
#define XtkTextFile		11
#define XtkTextString		12
#define XtkTextLength		13
#define XtkTextFont		14
#define XtkTextEventBindings	15
#define XtkTextWidth		16
#define XtkTextHeight 		17
#define XtkTextX		18
#define XtkTextY		19


/*-------------------------------------------*/

typedef struct _Dialog_Butt{
	  char		 label[Nchars];
/*	  char		 function[Nchars]; */
	  void		 (*function)();	 
	  char		 parameter[Nchars];
	  int		 param_type; 
	} Dialog_Butt;

typedef struct _TKdialog{
	  int 		 selected;
	  Window 	 w, parent;
	  int 		 x, y, width, height, borderwidth;
	  int 		 foreground, background, border;
	  Pixmap 	 foreground_pixmap, background_pixmap, border_pixmap;
	  char 		 name[Nchars], parentname[Nchars], label[Nchars];
	  char		 *entryptr[Nchars];
	  Dialog_Butt    *button;

	} TKdialog;



static Arg TKdialogarglist[] = {
	{XtNname,		(caddr_t) "name"},
	{XtNborderWidth,	(caddr_t) 1},
	{XtNwidth, 		(caddr_t) 10}, 
	{XtNheight, 		(caddr_t) 10},
	{XtNforeground, 	(caddr_t) NULL},
	{XtNbackground, 	(caddr_t) NULL},
	{XtNborder,     	(caddr_t) NULL},
	{XtNdefaultDistance, 	(caddr_t) 4},
	{XtNjustify,    	(caddr_t) XtjustifyCenter},
    	{XtNfunction,		(caddr_t) NULL},
	{XtNparameter,		(caddr_t) NULL},
       	{XtNnotify,      	(caddr_t) ButtonPressed}, 
	{XtNx,           	(caddr_t) 0}, 
        {XtNy,           	(caddr_t) 0}, 
       	{XtNlabel,      	(caddr_t) "label"},
    };


#define XtkDialogName 		0
#define XtkDialogBorderwidth	1
#define XtkDialogIntWidth 	2
#define XtkDialogIntHeight	3
#define XtkDialogForeground	4  
#define XtkDialogBackground	5
#define XtkDialogBorder		6
#define XtkDialogDefaultDistance 7
#define XtkDialogJustify	8
#define XtkDialogFunction	9
#define XtkDialogParameter	10
#define XtkDialogNotify		11
#define XtkDialogX		12
#define XtkDialogY		13
#define XtkDialogLabel		14
