
/* videoserver.h */

#ifndef VIDEOSERVER_H
#define VIDEOSERVER_H

#include "swtr_driver.h"
#include "rpd_driver.h"
#include "gdb.h"

/* port numbers for Inter-Process Communication (IPC) */

	/* head 0 will be 3330, head 1 will be 3340, etc. */

#define SERVER_BASE_ID	3330

/* ------------------------------------------------------------------- */

/* standard requests for all processes (including the server) (0-99)*/

#define	RESET		0
#define	UNLOCK		1
#define	LOCK		2

/* ------------------------------------------------------------------- */

	/* standard 'success code' for all requests */
	/* (the first field in the reply tuple) */
	/* NOTE: this does NOT apply to getting a video device table */

#define REQ_SUCCESS	0
#define REQ_FAILURE	1

	/* usually errcode in reply tuple is 0; this is returned when
		a device times out on a reset request */

#define DEVICE_NOT_RESPONDING	1

/* ----- SWTR codes ------------------------------------------------------------ */

	/* standard requests for a SWTR (100-199) */

#define SET_CHAN_SRC	100
#define INQUIRE		101

/* ------ RPD codes --------------------------------------------------------- */

	/* standard requests for an RPD (200-299) */

#define CMD		200
#define SEARCH		201
#define SEGPLAY		202
#define GETFRAME	203
#define VARSPEED	204
#define JOG		205
#define RECORD		206

/* ------ VIDEOSERVER codes ----------------------------------------------- */

	/* special requests for the video server only */

#define GET_DEVICE_TABLE	1000	/* returns special video_table reply */
#define IS_LOCKED		1001	/* returns standard reply */
#define SERVER_DEVICE		-1	/* pseudo-number in device table for server itself */


/* ------------------------------------------------------------------------ */

	/* all gdb request tuples to the videoserver take the following form */

static char *	
server_request_field_names[] = 
	{ "devnum", "type", "parm1", "parm2", "parm3", "parm4" };

static FIELD_TYPE 
server_request_field_types[] = 
	{ INTEGER_T, INTEGER_T, INTEGER_T, INTEGER_T, INTEGER_T, INTEGER_T };

#define SERVER_REQUEST_FIELDS	(sizeof(server_request_field_names) / sizeof(char *))

/* ------------------------------------------------------------------------ */

	/* all gdb request tuples to a monitor proc take the following form */

/* THIS SECTION IS OUT OF DATE -- IGNORE */

static char *	
std_request_field_names[] = 
	{ "type", "parm1", "parm2", "parm3", "parm4" };

static FIELD_TYPE 
std_request_field_types[] = 
	{ INTEGER_T, INTEGER_T, INTEGER_T, INTEGER_T, INTEGER_T };

#define STD_REQUEST_FIELDS	(sizeof(std_request_field_names) / sizeof(char *))

/* ------------------------------------------------------------------------ */

	/* all replies, except to a request for the device table, 
		take the following form */

static char *	
std_reply_field_names[] = 
	{ "success", "value", "errcode" };
static FIELD_TYPE 
std_reply_field_types[] = 
	{ INTEGER_T, INTEGER_T, INTEGER_T };

#define STD_REPLY_FIELDS	(sizeof(std_reply_field_names) / sizeof(char *))

/* ------------------------------------------------------------------------ */

	/* this is the format for a tuple in the relation which is sent back 
		by a request for the video device table (see video_conf.h) */

static char *	
vtbl_field_names[] = 
	{ "type", "name", "model", "monitor", "tty", "baud", "parity", "channel" };
static FIELD_TYPE 
vtbl_field_types[] = 
	{ INTEGER_T, STRING_T, STRING_T, STRING_T, STRING_T, INTEGER_T, INTEGER_T, STRING_T };

#define VTBL_FIELDS	(sizeof(vtbl_field_names) / sizeof(char *))

/* ----------------------------------------------------------------------- */

	/* function defs for vserv.c */

CONNECTION 	OpenLocalVideoServer();
CONNECTION 	OpenRemoteVideoServer();
int		PerformVideoService();
int		CloseVideoServer();

#endif VIDEOSERVER_H
