	
/* ev_tokens.h */

#ifndef EV_TOKENS_H
#define EV_TOKENS_H

/*#include <X10/Xlib.h>*/
#include "hash.h"

#define	EV_DEBUG(n,s)	if(ev_Debug && n>=ev_Debug) \
	{ int i; for(i=0;i<indentLevel;i++) printf("  "); printf s; }

#define IsInt(vp) ((vp)->type == T_int || (vp)->type == T_Cint ? 1 : 0)
#define IsFlt(vp) ((vp)->type == T_float || (vp)->type == T_Cflt ? 1 : 0)
#define IsStr(vp) ((vp)->type == T_string || (vp)->type == T_Cstr ? 1 : 0)
#define IsCvar(vp) (((vp)->type == T_Cint || (vp)->type == T_Cflt || (vp)->type == T_Cstr) ? 1:0)

#define C_comment1	'-'
#define C_comment2	'-'

#define T_NULL		0
#define T_comment1	5
#define T_comment2	6

#define T_float		95
#define	T_word		96
#define T_string	97
#define T_int		98
#define T_eof		99

#define EV_PARSE_ERR	-1
#define EV_PARSE_OK		0

#define MAXSTR	255

typedef struct
{
	int		type;
	int		line;
	char 	value[MAXSTR];
} TOKEN;			/* for token info while parsing */

#define MSG_CODESEG	16
#define FUNC_CODESEG	17
#define CFUNC_CODESEG	18

#define EXPR_MAGIC	-999	/* tree of vars, constants, operators, funcs */
#define VAR_MAGIC	-997	/* a variable or constant */
#define FCALL_MAGIC	-996	/* a call to a function */
#define WBIND_MAGIC	-995	/* a window binding for a handler */

typedef struct _enode		/* a node in the expression tree */
{
	int		magic;
	int		depth;
	int		op;		/* T_plus, T_minus, T_times, etc. */
	char *		left;		/* var or expr or NULL */
	char *		right;		/* var or expr or NULL */
} EXPR, *EXPR_PTR ;

typedef struct _vnode		/* a variable, or constant */
{
	int	magic;
	char *	name;
	char	IsStatic;		/* if true, variable does not get zeroed */
	char	IsParm;			/* if true, variable is a function parm */
	int	type;			/* T_int, T_flt, T_string; or T_C-stuff */
	char *	Cptr;			/* valid if T_C-something */
	struct	/* was a union; changed to work with char *sval, not sval[] */
	{
		int	ival;
		float 	fval;
		char	*sval;	/* generally, will be MAXSTR bytes long */
	} val;
	struct _vnode *next;
} VAR, *VAR_PTR;

/* following is for objects which are bound to C items */

#define MAXPARMS	12

typedef struct _cdcl
{
	char *	name;
	int	type;		/* int, flt, str, or func */

	/* rest is for functions */
	int	nparms;	
	int	ptype[MAXPARMS];
	int	retval;		/* int, flt, or str */

	struct _cdcl *next;
} C_DCL, *C_DCL_PTR;

typedef struct _cnode
{
	char *		name;
	int		type;		/* func, handler, or Cfunc */

	int		nparms;		/* constant; number it needs */
	VAR_PTR		parms[MAXPARMS];/* array where passed values are put */
	int		ptype[MAXPARMS];/* the EXPECTED type of each parm (for C) */
	VAR		returned;	/* where to put result of 'return' statement */
	int		retval;		/* type that the func returns (for C) */

	/* following is not used by C-funcs */
	VAR_PTR		varlist;	/* list of all variables, this proc */
	int		pc;		/* program counter; index into code */
	int		ninstr;		/* number of instructions */
	unsigned long * code;		/* the array of instructions */

	struct _cnode *	next;
} CODE, *CODE_PTR;

typedef struct _winbind
{
	int	magic;
	char *	wname;
	Window	w;
	struct _obj *obj;
	char *	ptr;		/* completely up to the programmer */
} WBINDING, *WBIND_PTR;
	
typedef struct _obj
{
	char *		name;
	VAR_PTR		common_vars;	/* common to all its funcs and handlers */
	CODE_PTR	codelist;	/* internal to this obj */
	WBIND_PTR	binding;	/* window that is bound to this obj */
	struct _obj *	next;
} OBJ, *OBJ_PTR;

typedef struct _env
{
	char *		name;
	VAR_PTR		constants;	/* all constants for the env */
	VAR_PTR		global_vars;	/* vars common to all objects */
	CODE_PTR	global_code;	/* funcs,handlers common to all objs */
	OBJ_PTR		objlist;	/* list of all objects in the env */
	HashTablePtr	obj_ht;		/* object name hash table */
	XAssocTable *	wb_table;	/* holds X window bindings */
	struct _env *	next;		/* doubt this will be used, but ... */
} ENVIRONMENT, *ENV_PTR;

/* following gets inserted into the code stream when a function is called */

typedef struct _fcall	
{
	int		magic;
	int		nparms;		/* number in this list */
	char *		parms[MAXPARMS];/* POINTERS to each variable/constant or expr or fcall */
	CODE_PTR	func;		/* the thing to call */
} FCALL, *FCALL_PTR;	

char *		OpStr();

ENV_PTR		newenv();
ENV_PTR		findenv();

CODE_PTR	newcode();
CODE_PTR	findcode();

OBJ_PTR		newobj();
OBJ_PTR		findobj();

C_DCL_PTR	newCdcl();
C_DCL_PTR	findCdcl();

WBIND_PTR	newbinding();

VAR_PTR		makevar();
VAR_PTR		findvar();
VAR_PTR		findint();
VAR_PTR		findstr();
VAR_PTR		findflt();
VAR_PTR		newvar();
VAR_PTR		newint();
VAR_PTR		ev_newstr();
VAR_PTR		newflt();
VAR_PTR		save_vars();

EXPR_PTR	newexpr();
EXPR_PTR	ev_Expression();

FCALL_PTR	newfcall();
FCALL_PTR	ev_Fcall();

typedef struct
{
	int	code;
	char *	string;
} RESERVED;			/* for reserved words */

#define CONTROL		100	/* range 100-199 reserved for flow-of-control */
#define IsControl(t)	((t)>=CONTROL && (t)-CONTROL<100)

#define T_on		100
#define T_if		101
#define T_else		102
#define T_repeat	103
#define T_function	104
#define T_object	105
#define T_environment	106
#define T_var		107
#define T_uses		108

#define SINGLE_OPERATORS 	"+-=*/"			/* always single-char ops */
#define DOUBLE_OPERATORS 	"<>&"			/* can be double-char ops */
#define SEP_OPERATORS 		",();{}"		/* to separate things */
#define ALL_OPERATORS		"+-=*/&<>,();{}"	/* all possible operators */

#define OPERATOR	200	/* range 200-299 reserved for operators */
#define IsOperator(t)	((t)>=OPERATOR && (t)-OPERATOR<100)

/* these are only single-character operators */
#define	T_plus		200
#define T_minus		201
#define T_equal		202
#define T_times		203
#define T_divide	204
#define T_cat		205		/* concatenate two strings */

/* these can be single or start of double-char operator */
#define T_LT		206		/* less than */
#define T_GT		207		/* greater than */

/* these are the double operators */
#define T_notequal	208	
#define T_LTE		209		/* less than or equal */
#define T_GTE		210		/* greater than or equal */
#define T_catspace	211		/* concat two strings with a space between */

/* these are the word operators */

#define T_and		225		/* logical and */
#define T_or		226		/* logical or */
#define T_not		227		/* logical not */

/* these are the separator operators */
#define	T_SEP_OPS	250

#define T_comma		250
#define T_begexpr	251		/* open parenthesis '(' */
#define T_endexpr	252		/* close parenthesis ')' */
#define T_cmdend	253		/* semicolon ';' */
#define T_begblock	254		/* open bracket '{' */
#define T_endblock	255		/* close bracket '}' */

#define IsUnaryOp(t)	( ((t) == T_not || (t) == T_minus) ? 1 : 0 )

#define COMMAND 	300	/* range 300-399 reserved for built-in commands */
#define IsCommand(t)	((t)>=COMMAND && (t)-COMMAND<100)

#define T_next		300		/* valid only inside Repeat */
#define T_exit		301		/* valid only inside Repeat */
#define T_return	302		/* valid only inside Function */

#define T_put		350
#define T_send		351

#define T_Cfunc		352		/* declare a C function */
#define T_Cint		353		/* declare a C int */
#define T_Cstr		354		/* declare a C string */
#define T_Cflt		355		/* declare a C float */

#define T_static	356		/* declare one of our vars to be static */

#define CONNECTOR	400	/* range 400-499 reserved for connectors */
#define IsConnector(t)	((t)>=CONNECTOR && (t)-CONNECTOR<100)

#define T_into		400
#define T_until		401
#define T_with		402
#define T_to		403
#define T_while		404
#define T_returns	405		/* part of a C function declaration */

#ifdef	EV_PARSE_C	/* -------- only for ev_Parse.c --------- */

int	ev_Debug = 0;

int	indentLevel = 0;
FILE *	theFile = stdin;
char	theLine[256];
char *	theLoc = theLine;
int	theLineNo = 0;
TOKEN	theToken;
int	eof = 0;
ENV_PTR	envlist = NULL;
HashTablePtr	C_ht = NULL;	/* hash table of C symbols */
C_DCL_PTR	C_declist;	/* C funcs and vars declarations */

RESERVED Controls[] =
	{
	
	T_on,			"on",
	T_if,			"if",
	T_else,			"else",
	T_repeat,		"repeat",
	T_function,		"function",

	T_object,		"object",
	T_environment,		"environment",
	T_var,			"var",

	T_uses,			"uses",
	
	};

#define NumControls (sizeof(Controls) / sizeof(RESERVED))

RESERVED Commands[] =
	{

	T_next,			"next",
	T_exit,			"exit",
	T_return,		"return",
	
	T_put,			"put",
	T_send,			"send",
	
	T_Cint,			"Cint",
	T_Cflt,			"Cflt",
	T_Cstr,			"Cstr",
	T_Cfunc,		"Cfunc",

	T_static,		"static",
	
	};
	
#define NumCommands (sizeof(Commands) / sizeof(RESERVED))

RESERVED Connectors[] = 
	{
	
	T_into,			"into",
	T_until,		"until",
	T_with,			"with",
	T_to,			"to",
	T_while,		"while",

	T_returns,		"returns",

	};
	
#define NumConnectors (sizeof(Connectors) / sizeof(RESERVED))

RESERVED Operators[] =
	{
	
	T_plus,		"+",
	T_minus,	"-",
	T_equal,	"=",
	T_times,	"*",
	T_divide,	"/",
	T_cat,		"&",
	T_LT,		"<",
	T_GT,		">",
	T_notequal,	"<>",
	T_LTE,		"<=",
	T_GTE,		">=",

	T_and,		"AND",
	T_or,		"OR",
	T_not,		"NOT",
	T_catspace,	"&&",

	T_comma,	",",
	T_begexpr,	"(",
	T_endexpr,	")",	
	T_cmdend,	";",
	T_begblock,	"{",
	T_endblock,	"}",
 
	};
 
#define NumOperators (sizeof(Operators) / sizeof(RESERVED))

#else	/* ------- for all others (not ev_parse.c) ---------- */

extern int	ev_Debug;

extern int	indentLevel;
extern FILE *	theFile;
extern char	theLine[256];
extern char *	theLoc;
extern int	theLineNo;
extern TOKEN	theToken;
extern int	eof;
extern ENV_PTR	envlist;
extern HashTablePtr	C_ht;
extern C_DCL_PTR	C_declist;	/* funcs and vars declarations */

#endif	/* ------ of conditional definitions ---------- */	

#endif EV_TOKENS_H
