
#include <stdio.h>

#include <a.out.h>
#include <stab.h>

main(argc,argv)
	int	argc;
	char *	argv[];
{
char fn[64];

	if( argc > 1 )
		strcpy(fn,argv[1]);
	else
		strcpy(fn,"a.out");

	nm( fn );
}

int
nm( fn )
	char *fn;
{
char *malloc();
struct exec e;
FILE *fp;
char *	strz;
struct nlist sym;
int	nsyms;
long	tabtop;
long	strsize;
long	type;
int	i;
char *	theStr;

	fp = fopen( fn, "r" );
	
	if( fread( &e, sizeof(struct exec), 1, fp ) != 1 )
	{
		printf("Bad exec read.\n");
		exit(-1);
	}
	if( N_BADMAG(e) )
	{
		printf("file %s has bad magic number\n",fn);
		exit(-1);
	}

	fseek( fp, N_STROFF(e), 0 );
	if( fread( &strsize, sizeof(strsize), 1, fp )!=1 )
	{
		printf("Bad strsize read\n");
		exit(-1);
	}

	strz = malloc( strsize );
	fseek( fp, N_STROFF(e), 0 );
	if( fread( strz, sizeof(*strz), strsize, fp ) != strsize )
	{
		printf("Bad strz read\n");
		exit(-1);
	}

	nsyms = e.a_syms / sizeof(struct nlist);

	tabtop = N_SYMOFF(e);
	for( i=0; i<nsyms; i++ )
	{
		fseek(fp,tabtop+(i*sizeof(struct nlist)),0);
		if( fread(&sym, sizeof(struct nlist), 1, fp ) != 1 )
			printf("Bad symbol read.\n");
		theStr = (char *)(strz + sym.n_un.n_strx);
		switch( sym.n_type )
		{
		case (N_TEXT | N_EXT):
			printf("%08x T %s\n",sym.n_value,theStr);
			break;
		case (N_DATA | N_EXT):
			printf("%08x D %s\n",sym.n_value,theStr);
			break;
		case (N_BSS | N_EXT):
			printf("%08x B %s\n",sym.n_value,theStr);
			break;
		default:
			break;
		}
	}
	fclose(fp);
	free( (char *) strz );
}
