
/* video_conf.h */

#ifndef VCONF
#define VCONF

#define VCONF_FILENAME	"/etc/video.conf"
#define MAXDEVS	32
#define LINE_ITEMS 7

#define SWTR_DEV	1
#define	RPD_DEV		2
#define INPUT_DEV	3	/* an uncontrolled channel source */
#define OUTPUT_DEV	4	/* a channel sink */

/* return codes */
#define VCONF_AOK		0	/* everything okay */
#define	VCONF_NO_FILE_ERR	-1	/* config file not found */
#define VCONF_NO_TABLE_ERR	-2	/* no table passed in */
#define VCONF_FILE_FMT_ERR	-3	/* error in config file */

typedef struct
{
	int	type;		/* code for SWTR, RPD, INPUT, OUTPUT */
	char	name[32];	/* name known to this system: DISC-1, etc. */
	char	model[32];	/* like DEC_VDP50 */
	char	mon_proc[64];	/* gdb server procedure */
	char	tty[16];	/* serial port; does not include '/dev' */
	int	baud;		/* like, 9600 */
	int	parity;		/* as in sys/ioctl.h: EVENP, ODDP, ANYP (0) */
	char	channel[16];	/* format is <swtr>:<chan> */
} VCONF_ENTRY;

typedef struct
{
	int		ndevs;
	VCONF_ENTRY 	dev[MAXDEVS];
} VCONF_DEVTABLE;

char *nameofparity();
char *nameoftype();

#endif !VCONF
