/* 
 * demo1.c - introductory example of X Toolkit Usage
 *
 * Make executable with:
 *	cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>

static void ButtonAction(tag)
caddr_t tag;
{
    printf("Button Pressed\n");
}

static char ButtonLabel[] = "Press Me";
static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) ButtonLabel},
    {XtAFunction, (caddr_t) ButtonAction},
    {NULL, NULL}	/* needed to terminate argument list */
};

void main()
{
    Display  *d;
    Window   bw;	/* button window */

    d = XOpenDisplay(NULL);

    XtInitToolkit();

    bw = XtCreateCommand(RootWindow, buttonArgs);

    /* widget clients normally position, size and map widget windows */
    XMoveWindow(bw, 100, 100);
    XMapWindow(bw);

    for(;;) {
	XEvent ev;

	XNextEvent(&ev);		/* Get next event */
	(void) XtDispatchXEvent(&ev);	/* Hand it to Toolkit Dispatcher */
    }
}
