/* 
 * demo1.c - introductory example of X Toolkit Usage
 *
 * Make executable with:
 *	cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>
#include "TextDisplay.h"

Window txt;

static void ButtonAction(tag)
caddr_t tag;
{
    printf("Button Pressed\n");
}

static char ButtonLabel[] = "Press Me";
static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) ButtonLabel},
    {XtAFunction, (caddr_t) ButtonAction},
    {NULL, NULL}	/* needed to terminate argument list */
};

static int string_len;
static char string[256];
static Arg txtArglist[] = {
    {XtAString, (caddr_t) string},
    {NULL, NULL}	/* needed to terminate argument list */
};

void main()
{
    Display  *d;
    Window   bw;	/* button window */

    d = XOpenDisplay(NULL);

    XtInitToolkit();

    bw = XtCreateCommand(RootWindow, buttonArgs);

    /* widget clients normally position, size and map widget windows */
    XMoveWindow(bw, 100, 100);
    XMapWindow(bw);

    /******************  Text window */
    sprintf(string,"Here is as fine a specimen of text as anyone would want.");
    string_len = strlen(string);
    txt = XtCreateStringText(RootWindow,txtArglist);
    XMoveWindow(txt, 200, 200);
    XMapWindow(txt);


    for(;;) {
	XEvent ev;

	XNextEvent(&ev);		/* Get next event */
	(void) XtDispatchXEvent(&ev);	/* Hand it to Toolkit Dispatcher */
    }
}
