/*
 *	sccsid:	@(#)TextDisplay.h	1.14	2/25/87
 */

/*
 * Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* File: TextDisplay.h */

#define MAXCUT	30000	/* Maximum number of characters that can be cut. */

#define LF	0x0a
#define CR	0x0d
#define TAB	0x09
#define BS	0x08
#define SP	0x20
#define DEL	0x7f
#define BSLASH	'\\'

#define EDITDONE 0
#define EDITERROR 1
#define POSITIONERROR 2

enum ScanDirection {left, right};
enum ScanType {positions, whitespace, eol, paragraph, file};

typedef long XtTextPosition;

typedef struct _XtTextBlock {
    int firstPos, length;
    char *ptr;
    } XtTextBlock, *TextBlockPtr;

typedef struct _XtTextSource {
    int (*read)();
    int (*replace)();
    XtTextPosition (*getLastPos)();
    int (*setLastPos)();
    XtTextPosition (*scan)();
    XtEditType (*editType)();
    int *data;
    } XtTextSource, *TextSourcePtr;

typedef struct _XtTextSink {
    int (*display)();
    int (*insertCursor)();
    int (*clearToBackground)();
    int (*findPosition)();
    int (*findDistance)();
    int (*resolve)();
    int (*maxLines)();
    int (*maxHeight)();
    int *data;
    } XtTextSink, *TextSinkPtr;

/* displayable text management data structures */

typedef struct _LineTableEntry {
    XtTextPosition position;
    int x, y, endX;
    } LineTableEntry, *LineTableEntryPtr;

/* Line Tables are n+1 long - e.g. last position displayed is in last lt entry */
typedef struct _LineTable {
    XtTextPosition top;	/* Top of the displayed text. */
    int lines;		/* How many lines in this table. */
    LineTableEntry *entry;	/* A dynamic array, one entry per line */
    } LineTable, *LineTablePtr;

enum InsertState {on, off};

enum SelectionType {nullSelection, posSelection, charSelection, wordSelection,
    lineSelection, paraSelection, allSelection};
enum SelectionMode {textSelect, textExtend};
enum SelectionAction {start, adjust, end};

typedef struct _TextSelection {
    XtTextPosition left, right;
    enum SelectionType type;
} TextSelection;

#define IsPositionVisible(ctx, pos)	(pos >= ctx->lt.entry[0].position && \
	    pos <= ctx->lt.entry[ctx->lt.lines].position)

/* Private Text Definitions */

typedef int (*ActionProc)();

typedef enum SelectionType SelectionArray[20];

typedef struct  _TextContext {
    XtTextSource *source;
    XtTextSink *sink;
    LineTable lt;
    XtTextPosition insertPos;
    TextSelection s;
    enum ScanDirection extendDir;
    TextSelection origSel;      /* the selection being modified */
    SelectionArray sarray;	/* Array to cycle for selections. */
    int width, height;		/* Dimensions of the text subwindow */
    int leftmargin;		/* Width of left margin. */
    int options;		/* wordbreak, scroll, etc. */
    unsigned short lasttime;	/* time stamp of last processed action */
    unsigned short time;        /* time stamp of last key or button action */
    unsigned int x, y;		/* x, y coords for key or button action */
    Window sbar;		/* The vertical scroll bar (none = 0).  */
    Window outer;		/* Win containing scrollbar & text (if any) */
    Window w;			/* Actual window containing text.  */
    XtTextPosition *updateFrom;	/* Array of start positions for update. */
    XtTextPosition *updateTo;	/* Array of end positions for update. */
    int numranges;		/* How many update ranges there are. */
    int maxranges;		/* How many update ranges we've space for. */
    short showposition;		/* True if we need to show the position. */
    XtTextPosition lastPos;	/* Last position of source. */
    Window dialog;		/* Window containing dialog, if any. */
    int borderWidth;		/* width of window border (if any) */
    XtEventsPtr eventTable;	/* Table for translation mgr. */
    caddr_t state;		/* translation manager state handle */
    Pixmap border, background;	/* window colors */
} TextContext, *TextContextPtr;

