 *  element contains map and target window pointer 
 *
 *  map{  int 		ndims;
 *	  int		d_cells[DIMENSIONS];
 *	  int		d_scale[DIMENSIONS];
 *	  int		d_delta[DIMENSIONS];
 *	  int 		display_dim[DIMENSIONS];
 *	  int		frame1;
 *	  ...
 *	}
 */


#define FLT (float)
#define VIDEOWIDTH 640
#define VIDEOHEIGHT 480

int
complex_video(element)
   ElementPtr element;
{

   int vx1, vy1, vx2, vy2;			/* virtual  		*/
   int sx1, sy1, sx2, sy2, sw, sh;		/* screen  (wdth, hght) */
   int col1, col2, row1, row2;			/* boundary cells	*/
   int xpt1, xpt2, ypt1, ypt2;			/* partials 		*/
   int xpx1, xpx2, ypx1, ypx2;			/* pixels   		*/
   int xmid, ymid;				/* midcells 		*/
   int dx, dy, cw, ch;				/* deltas, cell wdth,hght */

   /* get vx1,vy1,vx2,vy2 from dimensions */


   col1 = vx1 / dx;
   xpt1 = vx1 - (dx * col1);
   xpx1 = MAKE16( (FLT xpt1 / FLT cw) * VIDEOWIDTH);

   col2 = vx2 / dx;
   while((col2-1) + cw > vx2) --col2;
   xpt2 = vx2 - (dx * col2);
   xpx2 = MAKE16( (FLT xpt2 / FLT cw) * VIDEOWIDTH);

   row1 = vy1 / dy;
   ypt1 = vy1 - (dy * row1);
   ypx1 = (FLT ypt1 / FLT ch) * VIDEOHEIGHT;

   row2 = vy2 / dy;
   while((row2 - 1) + ch > vy2) --row2;
   ypt2 = vy2 - (dy * row2);
   ypx2 = (FLT ypt2 / FLT ch) * VIDEOHEIGHT;

   xmid = col2 - col1 - 1;
   ymid = row2 - row1 - 1;



