typedef struct _Marker {
	int		m_on, m_off;
	long		m_filepos;
	int		m_selected;
	struct _Marker	*m_prev, *m_next;
} Marker;

typedef struct _Timeline {
	struct _Editor		*t_editor;
	Window			t_editorwindow;
	Window			t_timelinewindow;
	Window			t_applicationwindow;
	char			*t_name;
	Font			t_font;
	FILE			*t_file;
	Marker			*t_markers;
	Marker			*t_current;
	Marker			*t_left, *t_right;
	int			t_number;
	struct _Timeline	*t_next;
} Timeline;

typedef struct _Editor {
	Window		e_window;
	Scrollbar	*e_scrollbar;
	Timeline	*e_timelines;
} Editor;

extern Editor	*TimelineInit();
extern int	TimelineSet();
extern Window	TimelineCreate();
extern void	TimelineProcess();
