/*
 *	$Source: /mit/projects/visual/RCS/readfile.c,v $
 *	$Header: readfile.c,v 1.2 87/07/08 09:59:43 hodges Locked $
 */


#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE  
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"

Screen *screen_sets[Screen_sets];

static Package  *pck, *tpck;	   
static Element *ele, *tele;
static Screen *scr, *tscr;
static Dimension *dim;
static Timer *tim;
static Map *map, *tmap; 


extern 	int getpackage();
extern	int getelement();
extern	int getscreen();
extern	int getmap();
extern	int getdimension();
extern	int getwidget();
extern  int gettimer();

Package *
readfile(datafile)
  char 		*datafile;
{
  static char 	*funcname = "Readfile";
  FILE 		*fp;
/*  Lkup_union    lkp, *lkup = &lkp; */
  char 		ln[Nchars], *line = ln;
  int 		n = 0;
  int 		dimcount = 0;
  int 		setcount = -1;


	if( (fp = fopen( datafile, "r" )) == NULL ) 
	{
		printf("%s: Can't open file %s\n",datafile);
		return (NULL);
	 }
	printf("%s: parsing %s...\n",funcname,datafile);

linecount = 0;

while( !feof(fp))
{
   if(n == 0)
     {
	if((line = get_data_line(fp)) != NULL)
	{
	    line[strlen(line) - 1] = NULL; /* knock off the \n for lookup */
	    if( (n = lookup(line)) == NULL) 
	    {
		printf("Lookup: No match for '%s', line %d\n"
			,line,linecount);
	     }
	 }
      }

	switch (n){

/*
*  Packages:
*
*  Mandatory components are allocated and linked here:  first element
*  first map, and first dimension.
*  
*  Packages are supressed until the first element has been filled.
*/
	case PACKAGE:
		    if(Supressed(MSK_PACKAGE)) 
		      signal_unexpected("package",funcname,linecount);
		    if((tpck = (Package *) calloc(1,sizeof(Package)))==NULL)
		    {
		      printf("%s: Can't allocate package\n",funcname);
		      return (NULL);
		     }
		    Supress(MSK_PACKAGE); 
		    if(pck) pck->next = tpck;
	            tpck->prev = pck;
		    pck = tpck;
		    if(!first_package) first_package = pck;


		    if((ele = (Element *) calloc(1,sizeof(Element))) == NULL)
		    {
		      printf("%s: Can't allocate element\n",funcname);
		      return (NULL);
		     }
		    Supress(MSK_ELEMENT);
		    tpck->element = ele;
		    ele->p = pck;

		    if((map=(Map *) calloc(1, sizeof(Map)))==NULL)
	   	    {
 		      printf("%s: Can't allocate map\n",funcname);
		      return (NULL);
		     }
		    Supress(MSK_MAP);
		    ele->map = map;
		    map->simple.type = Unused_map;

		    if((dim = (Dimension *) calloc(1, sizeof(Dimension)))
		       == NULL)
		    {
 		      printf("%s: Can't allocate dimension\n",funcname);
		      return (NULL);
		     }
		    Supress(MSK_DIMENSION);
		    tpck->dimension[0] = dim;
		    tpck->ndims = 0;
/*2/25*/
		    if((tim = (Timer *) calloc(1, sizeof(Timer)))
		       == NULL)
		    {
 		      printf("%s: Can't allocate timer\n",funcname);
		      return (NULL);
		     }
		    Supress(MSK_TIMER);
		    tpck->timer = tim;

 		    n = getpackage(fp, tpck); 
		    break;

       
/*  
*  Elements:
*
*  Elements cannot be declared before packages, as they are linked to
*  the most recently created package.  The first element is allocated
*  when the package is declared, where the supression flag is set.
*  When it comes here with the element declaration, it won't allocate
*  another element the first time through.
*
*  Also, a package declaration cannot be made until at least one element
*  has been declared for the preceding package; therefore, package
*  supresses itself, and the supression is lifted here when the 
*  element is created.  
*
*  On the map thing, see Maps below.  
*/
	case ELEMENT:
				
		    if(Supressed(MSK_ELEMENT))
		    {
		      tele = ele;
		      Unsupress(MSK_ELEMENT);
		     }
		    else
		    {
		      if((tele =(Element *) calloc(1,sizeof(Element)))==NULL)
		      {
			printf("%s: Can't allocate element\n",funcname);
			return (NULL);
		       }
		      tele->p = pck;
		      if(ele) ele->next = tele;
		      tele->prev = ele;
		      ele = tele;

		      if((map=(Map *) calloc(1, sizeof(Map)))==NULL)
	   	      {
 		         printf("%s: Can't allocate map\n",funcname);
		         return (NULL);
		       }
		      Supress(MSK_MAP);
		      ele->map = map;
		      map->simple.type = Unused_map;
		     }

		    n = getelement(fp, tele);

		    Unsupress(MSK_PACKAGE);		    
		    break;


/*
*  Screens:
*
*  Screens are grouped in sets.  The first case starts a new set and 
*  saves the head of the list in the screen_sets array, limited to
*  Screen_sets.  The second case attaches screens to the most recently
*  declared set.  Sub screens can also be allocated and linked to the 
*  list in the getscreen routine itself.  A bunch of screen declarations
*  can be punched in all at once without coming back here, and without
*  requiring the word "screen" to be included repeatedly (this only works
*  for the canonic form declaration).
*/
	case SCREENSET:
		    if((scr =(Screen *)calloc(1,sizeof(Screen)))==NULL
		       ||  ++setcount > Screen_sets)
		    {
		      printf("%s: Can't allocate screen\n",funcname);
		      return (NULL);
		     }
		    screen_sets[setcount] = scr;
		    Supress(MSK_SCREEN);
		    n = getscreen(fp, scr); 
		    break;


		    
	case SCREEN:
		    if((tscr = (Screen *)calloc(1,sizeof(Screen)))==NULL)
		    {
	      		printf("%s: Can't allocate screen\n",funcname);
	      		return (NULL);
	 	     }
		    if(scr) scr->next = tscr;
		    tscr->prev = scr;
		    scr = tscr;
		    n = getscreen(fp, tscr); 
		    break;


/*
*  Maps:
*
*  The first map is allocated at the time the package is allocated.  It
*  is bound to the first element of the package, which is created at the
*  same time.  At that point, maps are supressed, to indicate that a new
*  one is not needed yet.  When the map is declared it comes here to 
*  be filled.  If supressed, a new one is not created, but the map
*  is unsupressed, so future calls will make a map.
*
*/

	case MAP:
		    if(Supressed(MSK_MAP))
		    {
      			tmap = map;
			Unsupress(MSK_MAP);
		     }
		    else
		    {
		     	if((tmap =(Map *)calloc(1,sizeof(Map)))==NULL)
		     	{
				printf("%s: Can't allocate map\n",funcname);
				return (NULL);
		      	}
		      	if(map) map->simple.next = tmap;
		      	tmap->simple.prev = map;
		      	map = tmap;
		     }
		    n = getmap(fp, tmap, ele); 
		    break;
	



/*
*  Dimensions:
*
*  Dimensions are held in an array by the display package.  The number
*  is limited to MaxDims.
*/
	case DIMENSION:
		    if(Supressed(MSK_DIMENSION))
		      {
			Unsupress(MSK_DIMENSION);
			++pck->ndims;
		      }
		    else
		    {
		     if(++pck->ndims > MaxDims ||
			(dim =(Dimension *)calloc(1,sizeof(Dimension)))
			==NULL)
		        {
			  printf("%s: Can't allocate dimension\n",funcname);
			  return (NULL);
			}
		     pck->dimension[pck->ndims - 1] = dim;
		    }
		    n = getdimension(fp, dim); 
		    break;

/*
*  Timers:
*
*  Timers are held in a linked list by the package. Added 2/25. M.H.
*/

	case TIMER:
		    if(Supressed(MSK_TIMER))
		      {
			Unsupress(MSK_TIMER);
			++pck->ntimers;
		      }
		    else
		    {
		     if(++pck->ntimers > MaxTimers ||
	                (tim =(Timer *)calloc(1,sizeof(Timer)))
			==NULL)
		        {
			  printf("%s: Can't allocate timer\n",funcname);
			  return (NULL);
			}
		     pck->timer->prev = tim;
		     tim->next = pck->timer;
		     pck->timer = tim;
		    }
		    n = gettimer(fp, tim); 
		    break;


/*
*  Include:  recursive call to readfile
*
*/
	  case INCLUDE:
		    if( fscanf(fp,"file: %s\n",line) != 1 )
		      printf("Include file missing at line %d\n",++linecount);
		    n = 0;
		    linecountstack[linecountindex++] = linecount;
		    readfile(line);
		    linecount = linecountstack[--linecountindex];
		    break;


/*
*  Default:
*/
		  default:
		    printf("%s: error at line %d in %s:\n"
			   ,funcname,linecount,datafile);
		    printf("%s\n",line);
		    break;
		 
		}	/* end switch */
	
	 }	/* end while */
return (pck);

}	/* end func */

