#include <stdio.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <X10/Xlib.h>
#include </mit/StaffTools/include/X10/Xtlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#define VDISC
#include "vdisc.h"

extern Package *readfile();
extern CVideo *cvideo;

/*-------------------------------------*/
init_activate()
{
   Package 	*p;
   Element	*e;

	for(p = first_package; p; p = p->next)
	{
		if( p->init_active == YES)
		{
			p->active = YES;
			XMapWindow( (Window) p->window->w);

			for(e = p->element; e; e = e->next)
			{
				if(e->init_active == YES)
				{
	printf("init_activate: package `%s', element `%s'\n",p->name, e->name);
					e->active = YES;
					update_element(e);
				 }
	 		 }
		 }
	 }
			
}

/*-------------------------------------*/
timer_handler()
{
}
/*-------------------------------------*/
  static
get_time_remaining()
{
  struct itimerval	value;
  int			msecs;

	if( getitimer( ITIMER_REAL,&value ) == -1 )
	{
		perror( "set_timeout: getitimer");
		printf("getitimer wanked\n");
		return (-1);
	 }

	msecs = value.it_value.tv_sec * 1000;
	msecs += value.it_value.tv_usec / 1000;	  /* time left     */
	return (msecs);
}

/*-------------------------------------*/
  static
getelapsedtime(start_time)
  int		start_time;
{
  struct itimerval	value;
  int			msecs;

	if( getitimer( ITIMER_REAL,&value ) == -1 )
	{
		perror( "set_timeout: getitimer");
		printf("getitimer wanked\n");
		return (-1);
	 }

	msecs = value.it_value.tv_sec * 1000;
	msecs += value.it_value.tv_usec / 1000;	  /* time left     */
	msecs = start_time - msecs;                 /* time elapsed  */
	return (msecs);
}

/*-------------------------------------*/

main( argc,argv )
 int 		argc;
 char 		**argv;
{
  char 			fn[64];
  Package 		*vmp;
  static char   	*func = "main";
  char 			*getenv();
  int 			select_result, nfds = 1;
  struct timeval  	tmv, *time = &tmv;
  struct itimerval  	value, value2, ovalue;
  fd_set		fdset;
  XEvent 		ev;
  int			fd, msec, time_deficit,el;

	if( argc > 1 ) strcpy(fn,argv[1]);
	else 
	{
  		printf("what data file ? ");
  		gets( fn );
	 }

	if( !XOpenDisplay(0)) 
  	{
    		printf("main: failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    		exit(1);
  	 }


  	XtInitialize();
	if( XSetVideoDisplay() )
	{
  		disc = &vdsc;
  		disc->port = sony_open( 4800, getenv("DISCPORT") );
		if( disc->port < 0 )
			printf("YAGH! failed to open the disc\n");
	 }
printf(" going to readfile\n");
	vmp = readfile( fn );
	if( vmp == NULL ) exit(1);

printf(" going to makewindows\n");
	makewindows();
printf(" going to resolve\n");
	resolve_names();
printf(" going to init_act\n");
	init_activate();
        msec = new_timer_setting;
printf("after init, msec = %d\n",msec);
	if(msec)
	{
		time->tv_sec = msec/1000;
		time->tv_usec = (msec % 1000) * 1000;
		value.it_value.tv_sec = (msec/1000) + 1;
		value.it_value.tv_usec = (msec % 1000) * 1000;
	 }
	else
	{
		time->tv_sec = 0;
		time->tv_usec = 0;
 	        value.it_value.tv_sec = 0;
		value.it_value.tv_usec = 0;
	 }

  	FD_ZERO(&fdset);
  	FD_SET(dpyno(), &fdset);
        nfds = dpyno() + 1;

    	for(;;) 
	{
	   	if ( msec )
		{
			/*  start a timer for the XPending loop */
			if( (int)signal(SIGALRM, timer_handler) == -1 )
			{
				printf("%s: signal handler\n",func);
				exit (1);
		 	 }
			value2.it_value.tv_sec = 1;
			value2.it_value.tv_usec = 0;
			if( setitimer( ITIMER_REAL,&value2,&ovalue ) 
			    == -1 )
			{
				printf("%s: fault setting timer\n"
		    		    ,func);
				exit(1);
	 		 }

			/*  clear the event queue  */
			while( XPending())
			{
				XNextEvent(&ev);
				(void) XtDispatchEvent(&ev);
				if(ev.window == cvideo->window)
				    CVideoProcess(cvideo, ev);

			 }

			/*  get the elapsed time */
			time_deficit += getelapsedtime(1000);

			/*  kill the XPending timer  */

			value2.it_value.tv_sec = 0;
			value2.it_value.tv_usec = 0;
			if( setitimer( ITIMER_REAL,&value2,&ovalue ) 
			    == -1 )
			{
				printf("%s: fault setting timer\n"
		    		    ,func);
				exit(1);
	 		 }

			/* start the real timer  */
			if( setitimer( ITIMER_REAL,&value,&ovalue ) == -1 )
			{
				printf("%s: fault setting timer\n"
			    	,func);
				exit(1);
		 	 }

			/*  do the select */
printf("set select with time `%d'\n",msec);
  			select_result = select(nfds, &fdset, NULL, NULL, time);

		 }
		else
		{

			/*  start a timer for the XPending loop */
			if( (int)signal(SIGALRM, timer_handler) == -1 )
			{
				printf("%s: signal handler\n",func);
				exit (1);
		 	 }
			value.it_value.tv_sec = 1;
			value.it_value.tv_usec = 0;
			if( setitimer( ITIMER_REAL,&value,&ovalue ) 
			    == -1 )
			{
				printf("%s: fault setting timer\n"
		    		    ,func);
				exit(1);
	 		 }

			/* clear the event queue */
			while( XPending())
			{
				XNextEvent(&ev);
				(void) XtDispatchEvent(&ev);
				if(ev.window == cvideo->window)
				    CVideoProcess(cvideo, ev);
			 }

			/*  get the elapsed time */
			time_deficit += getelapsedtime(1000); 

			/*  kill the timer  */
			value.it_value.tv_sec = 0;
			value.it_value.tv_usec = 0;
			if( setitimer( ITIMER_REAL,&value,&ovalue ) 
			    == -1 )
			{
				printf("%s: fault setting timer\n"
		    		    ,func);
				exit(1);
	 		 }

			/*  now do the select */
printf("set select with no timer\n");
  			select_result = select(nfds, &fdset, NULL, NULL, 0);

		 }

  		switch(select_result)
  		{
			case -1:
				printf("%s: failed select\n",func);
				exit(1);
			case 0:
				if( (int)signal(SIGALRM, timer_handler) == -1 )
				{
					printf("%s: signal handler\n",func);
					exit (1);
			 	 }
				value.it_value.tv_sec = 1;
				value.it_value.tv_usec = 0;
				if( setitimer( ITIMER_REAL,&value,&ovalue ) 
				    == -1 )
				{
					printf("%s: fault setting timer\n"
			    		    ,func);
					exit(1);
		 		 }
				msec = update_timers();
				time_deficit += getelapsedtime(1000);

				if(msec)
				{
					if( (msec - time_deficit) > 0)
					{
					  msec -= time_deficit;
					  time_deficit = 0;
					  time->tv_sec = msec/1000;
					  time->tv_usec = (msec % 1000) * 1000;
					  value.it_value.tv_sec =(msec/1000)+1;
					  value.it_value.tv_usec = 
					    (msec % 1000) * 1000;
					 }
					else
					{
					   time_deficit -= (msec - 1);
					   msec = 1;
					   time->tv_sec = 0;
					   time->tv_usec = 1000;
					   value.it_value.tv_sec = 1;
					   value.it_value.tv_usec = 1000;
					 }	
printf("deficit %d, msec %d\n",time_deficit, msec);
				 }
				else
				{
					time->tv_sec = 0;
					time->tv_usec = 0;
				        value.it_value.tv_sec = 0;
					value.it_value.tv_usec = 0;
				 }
				break;
			default:
				msec = new_timer_setting
				    = (get_time_remaining());
				if( (int)signal(SIGALRM, timer_handler) == -1 )
				{
					printf("%s: signal handler\n",func);
					exit (1);
			 	 }
				value.it_value.tv_sec = 1;
				value.it_value.tv_usec = 0;
				if( setitimer( ITIMER_REAL,&value,&ovalue ) 
				    == -1 )
				{
					printf("%s: fault setting timer\n"
			    		    ,func);
					exit(1);
		 		 }

				XNextEvent(&ev);
    				(void) XtDispatchEvent(&ev);
				if(ev.window == cvideo->window)
				    CVideoProcess(cvideo, ev);

				time_deficit += getelapsedtime(1000);

				msec = new_timer_setting;

				if(msec)
				{
					msec -= 1000;  /* extra second */
					if( (msec - time_deficit) > 0)
					{
					  msec -= time_deficit;
					  time_deficit = 0;
					  time->tv_sec = msec/1000;
					  time->tv_usec = (msec % 1000) * 1000;
					  value.it_value.tv_sec =(msec/1000)+1;
					  value.it_value.tv_usec = 
					    (msec % 1000) * 1000;
					 }
					else
					{
					   time_deficit -= (msec - 1);
					   msec = 1;
					   time->tv_sec = 0;
					   time->tv_usec = 1000;
					   value.it_value.tv_sec = 1;
					   value.it_value.tv_usec = 1000;
					 }	
				 }
				else
				{
					   time->tv_sec = 0;
					   time->tv_usec = 0;
					   value.it_value.tv_sec = 0;
					   value.it_value.tv_usec = 0;
				 }
				break;
   		 }
    	 }

}



