
/* MenuMgr.h; RMS */

#ifndef MENU_MGR_H
#define MENU_MGR_H

typedef int (*FUNCTION)();

#define MAXITEMS	31	/* maximum items in a menu; # bits in long */

#define ITEM_IS_ENABLED(mp,n)	((mp)->menuFlags & (1<<(n)))
#define MENU_IS_ENABLED(mp)	ITEM_IS_ENABLED(mp,0)
#define ANY_ITEMS_ENABLED(mp)	((mp)->menuFlags & (~1))

#define styleNormal	0
#define styleBold	1
#define styleItalic	2

/* define 'magic numbers' for XAssocTable */
#define MBAR_MAGIC	1
#define MENU_MAGIC	2
#define ITEM_MAGIC	3
#define TEXT_MAGIC	4

/* define messages for the menu procs */
#define	msgDraw		0
#define msgChoose	1
#define msgCalcSize	2

#define MAXOF(a,b)	(((a)>(b))?(a):(b))

#define mm_EnableItem(mp,n)	((mp)->menuFlags |= (1<<(n)))
#define mm_DisableItem(mp,n)	((mp)->menuFlags &= ~(1<<(n)))
#define mm_EnableMenu(mp)	((mp)->menuFlags |= 1)
#define mm_DisableMenu(mp)	((mp)->menuFlags &= ~1)
#define mm_CalcMenuSize(mp)	(*(mp)->menuProc)(msgCalcSize,mp,0,0)
#define mm_SetNameCallback(mbp,f)	((mbp)->mbarNameCallback = (f))
#define mm_SetMenuCallback(mbp,f)	((mbp)->mbarMenuCallback = (f))
#define mm_MBarsHeight(d,f)	\
(2*MAXOF(f.fi[d->onstyle]->height,f.fi[d->offstyle]->height)+2*d->intNborder+2*d->extNborder+2*d->intMborder+2*d->extMborder)

#define mm_AllEvents \
	(KeyPressed | ButtonPressed | ButtonReleased |	\
	EnterWindow | LeaveWindow | ExposeWindow | ExposeRegion)

#define mm_MBarNameEvents \
	(ButtonPressed|ExposeRegion|ExposeWindow)
#define mm_MBarMenuEvents \
	(ButtonPressed|ExposeRegion|ExposeWindow)
#define mm_MBarParentEvents \
	(KeyPressed)
#define mm_MenuTitleEvents \
	(EnterWindow|LeaveWindow)
#define mm_MenuEvents \
	(0)
#define mm_ItemEvents \
	(ButtonReleased|EnterWindow|LeaveWindow)

#define MAXFONTS	3		/* Normal, Bold, Italic */

typedef struct
{
	char *	fontbase;		/* base name of font to use */
	int	fontsize;		/* base size */
	int	onstyle;		/* Normal, Bold, Italic */
	int	offstyle;		/* Normal, Bold, Italic */
	int	fgcolor;		/* foreground */
	int	bgcolor;		/* background */
	Pixmap	fgpixmap;		/* for tiling */
	Pixmap	bgpixmap;		/* for tiling */
	int	mousefg;		/* mouse foreground color */
	int	mousebg;		/* mouse background color */
	int	intIborder;		/* interior border, item window */
	int	intNborder;		/* interior border, name window */
	int	extNborder;		/* exterior border, name window */
	int	intMborder;		/* interior border, menu window */
	int	extMborder;		/* exterior border, menu window */
	int	xoff;			/* shadow x-offset */
	int	yoff;			/* shadow y-offset */
	int	flashtimes;		/* # times menu choice flashes */
	int	flashmsecs;		/* # millisecs to pause for flashes */
} Defaults, *DefsPtr;

#define	DEF_FONT	"helv"
#define	DEF_SIZE	12
#define	DEF_ONSTYLE	1
#define	DEF_OFFSTYLE	2
#define	DEF_FGCOLOR	BlackPixel
#define DEF_BGCOLOR	WhitePixel
#define DEF_MOUSEFG	BlackPixel
#define DEF_MOUSEBG	WhitePixel
#define DEF_INT_IBORDER	2
#define	DEF_INT_NBORDER	4
#define	DEF_EXT_NBORDER	2
#define	DEF_INT_MBORDER	4
#define DEF_EXT_MBORDER	1
#define DEF_XOFF	4
#define DEF_YOFF	4
#define DEF_FLASHTIMES	2
#define	DEF_FLASHMSECS	50
		
#ifdef 	MAKEDEFS			/* defined in MenuMgr_defs.c */
Defaults	mm_Defs;
#else
extern Defaults	mm_Defs;
#endif	!MAKEDEFS

typedef struct
{
	Pixmap		check;		/* for checking items */
	Pixmap		rv_check;	/* reverse video */
	Pixmap		kb;		/* for command key equivalents */
	Pixmap		rv_kb;		/* for reverse video */
	int		tallest;	/* index into fi[] */
	int		widest;		/* index into fi[] */
	FontInfo *	fi[MAXFONTS];
} FontFamily;

typedef struct _Item
{
	int		itemMagic;	/* unique to class 'Item' */
	char *		itemLabel;	/* label for this item */
	Window		itemWindow;	/* window id of the item box */
	struct _Menu *	itemMenu;	/* menu it comes from */
	int		itemNumber;	/* the number of this item */
	char *		itemData;	/* can be re-cast for different items */
	struct _Item *	itemNext;	/* next node in item list */
} Item, *ItemPtr;

typedef struct _TextData
{
	int		tdMagic;	/* unique to class 'TextData' */
	char		tdMarked;	/* item has a check mark */
	char		tdEquiv;	/* if true, keyboard equivalent */
	int		tdOnWidth;	/* width of item when enabled */
	int		tdOffWidth;	/* width of item when disabled */
} TextData, *TextDataPtr;

typedef struct _Menu
{
	int		menuMagic;	/* unique to class 'Menu' */
	char *		menuTitle;	/* name that goes in menu bar */
	int		menuID;		/* unique code for this menu */
	int		menuItemCount;	/* # items this menu */
	long		menuFlags;	/* bits; true for each item enabled */
	int		menuOn;		/* true if this menu title is on */
	int		menuLastItem;	/* last item highlighted this menu */
	FUNCTION	menuProc;	/* for Draw, Choose, CalcSize */
	int		menuLeftEdge;	/* relative to parent of menu bar */
	int		menuWidth;	/* updated by RecalcSize */
	int		menuHeight;	/* updated by RecalcSize */
	Window		menuWindow;	/* background window for items */
	Window		menuShadow;	/* shadow for item window */
	Pixmap		menuSaved;	/* what's underneath the menu */
	Window		menuTitleWindow;	/* for use in menu bar */
	int		menuTitleOnWidth;	/* size when title is 'on' */
	int		menuTitleOffWidth;	/* size when title is 'off' */
	struct _MenuBar *menuBar;	/* the menu bar we come from */
	Item *		menuItems;	/* the item list info */
	struct _Menu *	menuNext;	/* next link in list of menus */
} Menu, *MenuPtr;

typedef struct _MenuBar
{
	int		mbarMagic;	/* unique to class 'MenuBar' */
	char *		mbarName;	/* name of this menu bar */
	int		mbarMenuCount;	/* # of menus currently attached */
	int		mbarBottomEdge;	/* bottom of menu bar in parent */
	MenuPtr		mbarMList;	/* head of linked list of menus */
	FUNCTION	mbarNameCallback;	/* name bar callback */
	FUNCTION	mbarMenuCallback;	/* menu bar callback */
	Window		mbarNameWindow;	/* window for the name */
	Window		mbarMenuWindow;	/* window for the menu titles */
	Window		mbarParentWindow;	/* parent of both bars */
	Window		mbarMoveHackWindow;	/* lets us know when moved */
} MenuBar, *MenuBarPtr;

int		mm_InitMenus();
MenuBarPtr	mm_NewMenuBar();	/* creates */
MenuBarPtr	mm_GetMenuBar();	/* get from Xdefaults */
int		mm_PrintMenuBar();	/* debugging; shows contents */
int		mm_DisposeMenuBar();	/* destroys */
int		mm_InsertMenu();	/* adds menu in menu bar */
int		mm_DeleteMenu();	/* deletes menu from menu bar */

MenuPtr		mm_NewMenu();		/* creates */
MenuPtr		mm_GetMenu();		/* gets from Xdefaults */
int		mm_AppendItem();	/* adds item(s) to list */
int		mm_InsertItem();	/* adds item to list */
int		mm_PrintMenu();		/* debugging; shows contents */
int		mm_DisposeMenu();	/* destroys */

int		mm_CountMItems();	/* count items in a menu */
int		mm_CountMenus();	/* count menus in menu bar */
MenuPtr		mm_GetMHandle();	/* return MenuPtr given menuID */
char *		mm_GetItemLabel();	/* return label of item */
ItemPtr		mm_GetItemHandle();	/* return ptr to Item by number */
ItemPtr		mm_NewItem();		/* allocates */

#endif !MENU_MGR_H
