

environment video
{

	-- declarations section; all of the C globals which can be accessed

	Cint	theTextBuffer;

	Cfunc	QueryMouse( Cint, Cstr, Cstr, Cstr );
	Cfunc	XWarpMouse( Cint, Cint, Cint );
	Cfunc	mpause( Cint );
	Cfunc	theObj() returns Cstr;
	Cfunc	theEnv() returns Cstr;
	Cfunc	theCode() returns Cstr;

	Cfunc	GetAbsoluteXY( Cint, Cint, Cint, Cstr, Cstr ) returns Cint;
	Cfunc	XSync( Cint );
	Cfunc	XtTextUnsetSelection( Cint );
	Cfunc	GetTextEditorPos( Cint, Cstr, Cstr );
	Cfunc	SetTextEditorPos( Cint, Cint, Cint );
	Cfunc	GetTextEditorSelection( Cstr ) returns Cint;
	Cfunc	TextEditorReplace( Cint, Cint, Cint, Cstr );
	Cfunc	QueryWindow( Cint, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	ChangeWindow( Cint, Cint, Cint );
	Cfunc	QueryHeight( Cint ) returns Cint;
	Cfunc	XQueryWidth( Cstr, Cint ) returns Cint;
	Cfunc	GXCOPY() returns Cint;
	Cfunc	ALLPLANES() returns Cint;
	Cfunc	myWindow() returns Cint;
	Cfunc	GetAFont( Cstr ) returns Cint;
	Cfunc	ShowText( Cint, Cint, Cint, Cstr, Cint, Cint, Cint );
	Cfunc	theRoot() returns Cint;	
	Cfunc	WhitePM() returns Cint;
	Cfunc	BlackPM() returns Cint;
	Cfunc	MakeWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	RegisterWindow( Cint, Cstr );
	Cfunc	MapWindow( Cint );
	Cfunc	MapChildren( Cint );
	Cfunc	UnMap( Cint );
	Cfunc	ClearWindow( Cint );
	Cfunc	strlen( Cstr ) returns Cint;
	Cfunc	FlushEvents();
	Cfunc	Beep();
	Cfunc	MoveWindow( Cint, Cint, Cint );
	Cfunc	MakeButton( Cint, Cint, Cint, Cstr ) returns Cint;
	Cfunc	MakeButtonBox( Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	AddToButtonBox( Cint, Cint );
	Cfunc	MakeAskFor( Cint, Cstr, Cstr, Cint, Cint ) returns Cint;
	Cfunc	GetAskForString( Cint ) returns Cstr;
	Cfunc	MakeTextEditor( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	XtSendDestroyNotify( Cint );
	Cfunc	XDestroyWindow( Cint );
	Cfunc	Quit();
	Cfunc	MakeMenuBarWindow( Cint, Cstr, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	MenuBarHeight() returns Cint;
	Cfunc	SetIconWindow( Cint, Cint );
	Cfunc	IconSwitch( Cint );
	Cfunc	MakePixmap( Cstr, Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XPixmapPut( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );
	Cfunc	MakeCursor( Cstr, Cstr, Cstr, Cstr ) returns Cint;
	Cfunc	XDefineCursor( Cint, Cint );
	Cfunc	XUndefineCursor( Cint );
	Cfunc	GetColor( Cstr ) returns Cint;

	Cfunc	RegisterTW( Cint );
	Cfunc	DeRegisterTW( Cint );
	Cfunc	WindowFromTW( Cint ) returns Cint;

	Cfunc	TextCreate( Cint, Cint, Cint, Cint, Cint, 
			Cstr, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	TextDestroy( Cint );
	Cfunc	TextClear( Cint );
	Cfunc	TextRedisplay( Cint );
	Cfunc	TextPutString( Cint, Cstr );
	Cfunc	TextPutChar( Cint, Cint );
	Cfunc	TextPutLine( Cint, Cstr );
	Cfunc	TextFlush( Cint );	
	
	Cfunc	XCreateVideoWindow( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	XStartVideo( Cint, Cint, Cint, Cint );
	Cfunc	XStillVideo( Cint, Cint, Cint, Cint, Cint, Cint, Cint );
	Cfunc	XScaleVideo( Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint, Cint );

	Cfunc	InitVideoDevs() returns Cint;
	Cfunc	GetDefaultRPD() returns Cint;
	Cfunc	RPDreset( Cint ) returns Cint;
	Cfunc	RPDcmd( Cint, Cstr ) returns Cint;
	Cfunc	RPDsearch( Cint, Cint, Cint ) returns Cint;
	Cfunc	RPDsegplay( Cint, Cint, Cint, Cint ) returns Cint;
	Cfunc	RPDgetframe( Cint ) returns Cint;
	Cfunc	RPDvarspeed( Cint, Cstr ) returns Cint;
	Cfunc	RPDjog( Cint, Cint ) returns Cint;
	
	-- end of C declarations

	var 	theFont;
	var	theCursor;
	var	theRPD;
	var	theVideoHack;

	function GetIconWindowSize( iw, ih, name, f, width, height )
	{
		put XQueryWidth( name, f ) into strWidth;
		put QueryHeight( f ) into strHeight;
		put (strWidth+20) into w;
		if( (iw+20) > w )
			{ put (iw+20) into w; }
		put ((strHeight+ih)+30) into h;
		put w into width;	-- return this value
		put h into height;	-- return this value
	}

	function PlotIconText( window, iw, ih, name, f )
	{
		put XQueryWidth( name, f ) into strWidth;
		QueryWindow( window, w,h,x,y, bdr, mapped, type, assoc );
		put ((w-strWidth)/2) into destSX;
		put (ih+20) into destSY;
		ShowText( window, destSX,destSY, name, strlen(name), f, 0 );
	}

	on OpenEnv
	{
		if( InitVideoDevs() < 0 )
			{ Quit(); }

		put GetDefaultRPD() into theRPD;

		put XCreateVideoWindow( theRoot(), 1264,0,16,16,0,
			WhitePM(), BlackPM() ) into theVideoHack;
		MapWindow( theVideoHack );
		XSync(0);
		XStillVideo( theVideoHack, 0,0,0,0,16,16 );
		XSync(0);
		mpause( 100 );
		UnMap( theVideoHack );			

		put GetAFont( "timrom10b" ) into theFont;
		put MakeCursor( "left_ptr.cursor", "left_ptr_mask.cursor",
			"black", "white" ) into theCursor;
		XDefineCursor( theRoot(), theCursor );

		put MakeButtonBox( theRoot(), 800,100,300,100 ) into bbw;
		AddToButtonBox( bbw, MakeButton( bbw, 0,0, "Quit" ) );

		MapWindow( bbw );
		MapChildren( bbw );

		send "reset"  to "videodisc";

		send "create 100 100 640 482" to "vidwin";
		put ("setframe" && 34510) into theMsg;
		send theMsg to "vidwin";
		send "show" to "vidwin";

		-- send "create 100 600 640 482" to "vidwin2";
		-- put ("setframe" && 34526) into theMsg;
		-- send theMsg to "vidwin2";
		-- send "show" to "vidwin2";

		FlushEvents();
	}

	object Quit
	{
		on Activate
		{ Quit(); }
	}

	object videodisc
	{
		on reset
		{
			RPDreset( theRPD );
		}
		on cmd		str
		{
			RPDcmd( theRPD, str );
		}
		on search	frame,wait
		{
			RPDsearch( theRPD, frame, wait );
		}
		on segplay	in,out,wait
		{
			RPDsegplay(theRPD,in,out,wait);
		}
		on getframe	replyobj,replyhandler
		{
			put (replyhandler && RPDgetframe(theRPD)) into theMsg;
			send theMsg to replyobj;
		}
		on varspeed	str
		{
			RPDvarspeed( theRPD, str );
		}
		on jog		num
		{
			RPDjog( theRPD, num );
		}
	}

	object vidwin
	{
	var	inited;
	var	first;
	var	myFrame;
	var	HackWindow;
	var	vx;
	var	vy;
	var	vw;
	var	vh;

		on create	x,y,w,h
		{
			if( inited = 0 )
			{
				put XCreateVideoWindow( theRoot(), x,y,
					w,h,2,WhitePM(),BlackPM() )
						into theWin;
				RegisterWindow( theWin, theObj() );
				put (("SetIcon" && theWin) && "`Still Video`")
					into theMsg;
				send theMsg to "IconWindow";
				-- find abs coords of 0,0 in theWin
				GetAbsoluteXY( theWin, 0,0, theX, theY );
				put MakeWindow( theRoot(), theX,theY,1,1,
					0,BlackPM(),WhitePM() ) 
					into HackWindow;
				put x into vx;
				put y into vy;
				put w into vw;
				put h into vh;
				put 1 into inited;
			}
		}

		on show
		{
			MapWindow( myWindow() );
			MapWindow( HackWindow );
		}

		on hide
		{
			UnMap( myWindow() );
			UnMap( HackWindow );
		}

		on setframe	it
		{
			put it into myFrame;
			put ("setframe" && it) into theMsg;
			send theMsg to "IconWindow";
		}

		on ExposeWindow	subw
		{
			GetAbsoluteXY( HackWindow, 0,0, hx, hy );
			GetAbsoluteXY( myWindow(), 0,0, x, y );
			put (("search" && myFrame) && 1) into theMsg;
			send theMsg to "videodisc";

			QueryMouse( theRoot(), saveX, saveY, subW );
			XWarpMouse( myWindow(), 0,0 );
			XSync(0);
			XStillVideo( myWindow(), 0,0, 0,0,vw,vh );
			XSync(0);
			XWarpMouse( theRoot(), saveX, saveY );			

			if( (hx <> x) OR (hy <> y) )
			{
				MoveWindow( HackWindow, x, y );
			}
			MapWindow( HackWindow );
		}

		on DoubleClick	which,x,y,keymask
		{
			put ("SetIcon" && myWindow()) into theMsg;
			put (theMsg && (("`Still Video:" && myFrame) & "`") )
				into theMsg;
			send theMsg to "IconWindow";
			IconSwitch( myWindow() );
			UnMap( HackWindow );
		}

		on ButtonReleased	which,x,y,keymask
		{	-- so XS doesn't complain; needs ButtonReleased for DoubleClick
		}
	}

	object IconWindow
	{
		var	theIcon;
		var	IconW;
		var	IconH;
		var	IconWindowW;
		var	IconWindowH;
		var	IconName;
		var	IconFrame;
		var	VideoWindow;
		var	HackWindow;

		on setframe	frm
		{
			put frm into IconFrame;
		}

		on SetIcon	mainWindow,theName
		{
			if( theIcon = 0 )	-- if IconWindow is not made yet
			{
				put 128 into IconW;
				put 96 into IconH;
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				put MakeWindow( theRoot(), 244, 256, 
					IconWindowW, IconWindowH,
					2, BlackPM(), WhitePM() )
						into theIcon;
				RegisterWindow( theIcon, theObj() );
				put XCreateVideoWindow( theIcon, 
					((IconWindowW-IconW)/2),10,
					IconW,IconH,0,WhitePM(),BlackPM() )
						into VideoWindow;
				put theName into IconName;
				SetIconWindow( mainWindow, myWindow() );
				GetAbsoluteXY( theIcon, 0,0, theX, theY );
				put MakeWindow( theRoot(), theX,theY,1,1,
					0,WhitePM(),BlackPM() ) 
					into HackWindow;
			}
			else
			{
				put theName into IconName;
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				ChangeWindow( theIcon, IconWindowW, IconWindowH );
				MoveWindow( VideoWindow,((IconWindowW-IconW)/2),10 );
			}
		}

		on ExposeWindow	subw
		{
			GetAbsoluteXY( HackWindow, 0,0, hx, hy );
			GetAbsoluteXY( myWindow(), 0,0, x, y );
			if( (hx <> x) OR (hy <> y) )
			{
				MoveWindow( HackWindow, x, y );
			}
			MapWindow( HackWindow );
			PlotIconText( myWindow(), IconW, IconH, IconName, theFont );
			put (("search" && IconFrame) && "1") into theMsg;
			send theMsg to "videodisc";
			MapChildren( theIcon );
			XSync(0);
			XScaleVideo( VideoWindow, 0,0,640,482,0,0,IconW,IconH );
			XSync(0);
		}

		on DoubleClick	which,x,y,keymask
		{
			IconSwitch( myWindow() );
			UnMap( HackWindow );
		}

		on ButtonReleased	which,x,y,keymask
		{	-- so XS doesn't complain
		}
	}

	object vidwin2
	{
	var	inited;
	var	first;
	var	myFrame;
	var	HackWindow;
	var	vx;
	var	vy;
	var	vw;
	var	vh;

		on create	x,y,w,h
		{
			if( inited = 0 )
			{
				put XCreateVideoWindow( theRoot(), x,y,
					w,h,2,WhitePM(),BlackPM() )
						into theWin;
				RegisterWindow( theWin, theObj() );
				put (("SetIcon" && theWin) && "`Still Video`")
					into theMsg;
				send theMsg to "IconWindow2";
				-- find abs coords of 0,0 in theWin
				GetAbsoluteXY( theWin, 0,0, theX, theY );
				put MakeWindow( theRoot(), theX,theY,1,1,
					0,BlackPM(),WhitePM() ) 
					into HackWindow;
				put x into vx;
				put y into vy;
				put w into vw;
				put h into vh;
				put 1 into inited;
			}
		}

		on show
		{
			MapWindow( myWindow() );
			MapWindow( HackWindow );
		}

		on hide
		{
			UnMap( myWindow() );
			UnMap( HackWindow );
		}

		on setframe	it
		{
			put it into myFrame;
			put ("setframe" && it) into theMsg;
			send theMsg to "IconWindow2";
		}

		on ExposeWindow	subw
		{
		static	okay;	-- for some reason, first expose is wacky

			GetAbsoluteXY( HackWindow, 0,0, hx, hy );
			GetAbsoluteXY( myWindow(), 0,0, x, y );
			put (("search" && myFrame) && 1) into theMsg;
			send theMsg to "videodisc";
			FlushEvents();
			XSync(0);
			if( NOT okay )
			{
				XScaleVideo( myWindow(), 0,0, 640,482,0,0,vw,vh );
				put 1 into okay;
			}
			else
			{
				XStillVideo( myWindow(), 0,0, 0,0,vw,vh );
			}
			FlushEvents();
			XSync(0);
			if( (hx <> x) OR (hy <> y) )
			{
				MoveWindow( HackWindow, x, y );
			}
			MapWindow( HackWindow );
		}

		on DoubleClick	which,x,y,keymask
		{
			put ("SetIcon" && myWindow()) into theMsg;
			put (theMsg && (("`Still Video:" && myFrame) & "`") )
				into theMsg;
			send theMsg to "IconWindow2";
			IconSwitch( myWindow() );
			UnMap( HackWindow );
		}

		on ButtonReleased	which,x,y,keymask
		{	-- so XS doesn't complain; needs ButtonReleased for DoubleClick
		}
	}

	object IconWindow2
	{
		var	theIcon;
		var	IconW;
		var	IconH;
		var	IconWindowW;
		var	IconWindowH;
		var	IconName;
		var	IconFrame;
		var	VideoWindow;
		var	HackWindow;

		on setframe	frm
		{
			put frm into IconFrame;
		}

		on SetIcon	mainWindow,theName
		{
			if( theIcon = 0 )	-- if IconWindow is not made yet
			{
				put 128 into IconW;
				put 96 into IconH;
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				put MakeWindow( theRoot(), 244, 256, 
					IconWindowW, IconWindowH,
					2, BlackPM(), WhitePM() )
						into theIcon;
				RegisterWindow( theIcon, theObj() );
				put XCreateVideoWindow( theIcon, 
					((IconWindowW-IconW)/2),10,
					IconW,IconH,0,WhitePM(),BlackPM() )
						into VideoWindow;
				put theName into IconName;
				SetIconWindow( mainWindow, myWindow() );
				GetAbsoluteXY( theIcon, 0,0, theX, theY );
				put MakeWindow( theRoot(), theX,theY,1,1,
					0,WhitePM(),BlackPM() ) 
					into HackWindow;
			}
			else
			{
				put theName into IconName;
				GetIconWindowSize( IconW, IconH, theName, theFont,
					IconWindowW, IconWindowH );
				ChangeWindow( theIcon, IconWindowW, IconWindowH );
				MoveWindow( VideoWindow,((IconWindowW-IconW)/2),10 );
			}
		}

		on ExposeWindow	subw
		{
			GetAbsoluteXY( HackWindow, 0,0, hx, hy );
			GetAbsoluteXY( myWindow(), 0,0, x, y );
			if( (hx <> x) OR (hy <> y) )
			{
				MoveWindow( HackWindow, x, y );
			}
			MapWindow( HackWindow );
			PlotIconText( myWindow(), IconW, IconH, IconName, theFont );
			put (("search" && IconFrame) && "1") into theMsg;
			send theMsg to "videodisc";
			MapChildren( theIcon );
			XSync(0);
			XScaleVideo( VideoWindow, 0,0,640,482,0,0,IconW,IconH );
			XSync(0);
		}

		on DoubleClick	which,x,y,keymask
		{
			IconSwitch( myWindow() );
			UnMap( HackWindow );
		}

		on ButtonReleased	which,x,y,keymask
		{	-- so XS doesn't complain
		}
	}

}
