/* 
 * scr.c - modifies demo1; adds a scroll bar
 *
 * Make executable with:
 *	cc -o demo1 demo1.c -lXt -lX
 */

#include <X/Xlib.h>
#include "Toolkit.h"
#include <stdio.h>
#include <signal.h>
#include <sys/time.h>

#define TIMELIMIT 60

Window windowid;
    Window   bw;	/* button window */
    Window   sw;  /*scroll window */
XEvent rp, *rep = &rp;
Font f;
int len;
char *msg[30];
int time;

static void ButtonAction(tag)
caddr_t tag;
{
    printf("Button Pressed\n");
}




static char ButtonLabel[] = "Press Me";
static Arg buttonArgs[] = {
    {XtALabel, (caddr_t) ButtonLabel},
    {XtAFunction, (caddr_t) ButtonAction},
    {NULL, NULL}	/* needed to terminate argument list */
};



static void Scr1(scrW, cliW, intpos)
  Window scrW;
  Window cliW;
  int intpos;
{
  printf("pos %d\n",intpos);
}

static void Thmb(scrW, cliW, tp, sp)
  Window scrW;
  Window cliW;
  float tp, sp;
{
  printf("top percent %.2f  shown percent %.2f\n",tp,sp);
  time = (tp/100)*TIMELIMIT;
  sprintf(msg,"Time %d   ",time);
  len = strlen(msg);

  XText(windowid,
	100,10,msg,len,f,BlackPixel,WhitePixel);
  XFlush();
  
}
  
static Arg scrargs[] = {
  {XtAOrientation, (caddr_t) XtAhorizontal},
  {XtAWidth, (caddr_t) 400},
  {XtAHeight, (caddr_t) 20},
  {XtAScrollUpDownProc, (caddr_t) Scr1},
  {XtAThumbProc, (caddr_t) Thmb},
  {NULL, NULL}
};



int timer();
int tries = 0;
int time;



/********************************************************
*  MAIN
*/

void main()
{
    Display  *d;


int count = 0;
int len;
char *msg[30];

struct itimerval timvl;
struct itimerval *timval = &timvl;
struct itimerval timovl, *timoval = &timovl;
int timetype;


timvl.it_value.tv_sec = 1;
timvl.it_value.tv_usec = 0;
timvl.it_interval.tv_sec = 1;
timvl.it_interval.tv_usec = 0;



if(++tries == 1 && XOpenDisplay(0) == 0)
  { printf("Failed XOpenDisplay on %s\n",getenv("DISPLAY"));
    exit(1);
   }

if(tries == 1){
  windowid = XCreateWindow(RootWindow,
			 50,
			 50,
			 400,
			 200,
			 3,
			 BlackPixmap,
			 WhitePixmap);


  XMapWindow(windowid);

  if((f = XGetFont("timrom12b")) == 0)
    {  printf("Failed XGetFont timrom12b\n");
       exit(1);
     }


  XText(windowid,
	100,
	80,
	"Bonjour",
	7,
	f,
	BlackPixel,
	WhitePixel);



  XSelectInput(windowid, 1);




    XtInitToolkit();

    bw = XtCreateCommand(windowid, buttonArgs);

    /* widget clients normally position, size and map widget windows */
    XMoveWindow(bw, 0,0);
    XMapWindow(bw);


    sw = XtCreateScrollBar(windowid, scrargs);

    XMoveWindow(sw, 0, 175);
    XMapWindow(sw);


  setitimer(timetype,timval,0);

  (*signal(SIGALRM,timer))();
}







    for(;;) {
	XEvent ev;

	XNextEvent(&ev);		/* Get next event */
	(void) XtDispatchXEvent(&ev);	/* Hand it to Toolkit Dispatcher */
    }
}









int 
timer()
{

  char *msg[30];
  int len;
  float tp,sp;
  float fti;


  if(++time > TIMELIMIT) exit(1);


  sprintf(msg,"Time %d  ",time);
  len = strlen(msg);

  XText(windowid,
	100,10,msg,len,f,BlackPixel,WhitePixel);
  XFlush();

  tp = ((fti=time)/TIMELIMIT)*100;
  sp = 0; 
  XtSetScrollBarPercentages(sw,tp,sp);

}
