// This is -*- c++ -*- code

// $Id: test_board.h,v 1.5 1995/11/21 09:56:54 jered Exp $

#ifndef __TEST_BOARD_H__
#define __TEST_BOARD_H__

#include <6170.h>
#include <typeinfo.h>
#include "board.h"

class test_board : public board {
 
    // Overview: This class is a subtype of class board, for the test
    // game described in the documentation.

  public:
    // Constructors and Destructors

    test_board();
    // Effects: Constructs a test_board that is not
    // associated with any game.  

    virtual ~test_board();

    // Methods
    virtual bool is_legal_move(move &m, const player *p) const; 
    // Effects: See board.h

    virtual game::move_result apply(move &m, player *p);
    // Effects: See board.h

    virtual bool unapply(move &m, const player *p);
    // Effects: See board.h

    virtual player *winner();
    // Effects: See board.h

    virtual http_response *get(string request, extensions *extras);
    // Effects: See board.h

    virtual void display(extensions *ext, ostream& body) const;
    // Effects: See board.h

    virtual generator <move *> * valid_moves() const;
    // Effects: See board.h

    virtual board::value eval_move_delta(move &m, const player *p) const;
    // Effects: See board.h
    
    virtual board::value evaluate(const player *p) const;
    // Effects: See board.h

    virtual void* force (typeinfo_t &t);

    static typeinfo_t typeinfo;

  private:
    void operator= (test_board &);
    int highest_taken;       // Highest 'piece' taken
    player *won_player;       // The player who has won.
};
#endif
