// Copyright 1995 Barbara Liskov

#ifndef _PATTERN_H
#define _PATTERN_H

#include "6170.h"

class pattern {
    // Overview: A "pattern" represents a simplified version of the ordinary
    //  Unix filename patterns.  The purpose of a pattern is to be compared
    //  with strings to see whether they match it. In the textual
    //  representation of a "pattern", all characters
    //  represent themselves, except for asterisk ("*"), which represents an
    //  arbitrarily long sequence of characters, and left bracket ("["),
    //  which begins a list of characters one of which can occur at this point.
    //  The list of characters is terminated by a right bracket ("]"). If the
    //  list of characters begins with a caret ("^"), the characters in the
    //  list are not allowed at this point. Thus, the pattern "a*[^x]*b"
    //  represents any sequence of characters that starts with "a", ends
    //  with "b", and has some character in between that is not "x".
public:
    virtual bool match(string s) = 0;
        // effects  Return whether "s" matches "this".
    virtual string unparse() = 0;
        // effects  Return a textual representation of "p".
};

pattern *create_simple_pattern(string s);
  // effects  Return a pattern whose textual representation is "s".
  //          If "s" is not a valid pattern specifier, return 0.


#endif /* _PATTERN_H */
