#ifndef _OUR_TIME_H
#define _OUR_TIME_H

#include "6170.h"

extern int get_epoch_time(int year, int month, int day, int hours, int minute);
// effects Converts the given date and time and returns the epoch time (time
//         since 12am, Jan 1, 1970, GMT).

extern int get_year(int month, int day, int hours, int minutes);
// effects Returns the year such that the time specified is the most
//         recent possible instance in the past.


extern bool query_time_to_int(string time, int &time_in_seconds, bool low_end);
// modifies time_in_seconds
// effects parses time and modifies time_in_seconds to contain the number
//         of seconds since Jan 1, 1970
//         If low_end is true and time is of type "mm/dd/yyyy", 
//         the time of the day chosen is 0:00
//         If low_end is false and time is of type "mm/dd/yyyy", 
//         the time of the day chosen is 23:59
//         Returns FALSE if time is not either of the two formats:
//         (1) "mm/dd/yyyy" or 
//         (2) "mm/dd/hh:mm"

extern bool get_query_times(string times, int min_allowed_time,
		     int max_allowed_time,
		     int& lowtime, int& hightime);
// modifies lowtime, hightime
// effects  parses "dates" and puts the range of dates specified into
//          lowtime and hightime, in  seconds since January 1, 1970.
//          min_allowed_time and max_allowed_time are the lowest and
//          highest time values acceptable (used in case of *)
//          Returns true iff:
//          (a) "times" is in one of these formats: "*", "x..y", 
//              "x..", or "..y"
//          (b) min_allowed <= x <= y <= max_allowed
//          (c) x or y is in a format specified by parse_date.
//              For the allowed specifications of a date see parse_date.

extern inline int get_month (string s);
// effects returns the corresponding number of a month.
//         For example, returns 1 for "Jan", 2 for "Feb" and so on
//         returns 0 if  s is not of length 3 or does not represent
//         the first 3 letters of a month with the first char in upper
//         case and next two chars in lower case.

extern bool db_time_to_int(string time, int& time_in_seconds);
// effects parses time and modifies time_in_seconds to contain the time in
//         seconds since January 1, 1970, GMT
//         String time is in either of the two formats: 
//         (1) "Mmm [d]d  yyyy" or 
//         (2) "Mmm [d]d hh:mm"
//         where  Mmm represents the first 3 characters of a month  with 
//         the first letter in upper case and the other two in lower case
//	       yyyy is the year;  hh and mm are the hour and minutes.
//         [d]d denotes the day of the month.  [d]d says that the day
//         may be one or two characters. Note, however that hours and
//         and minutes have to be exactly 2 characters each
//         Examples of acceptable dates: "Jan  1 1993" "May 30 04:23"
// returns TRUE iff string time is not in the format (1) or (2)
    
#endif /* _OUR_TIME_H */
