#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif


/* etale.c */
void initialize_ale_error_table P_((void));

/* etalw.c */
void initialize_alw_error_table P_((void));

/* setuser.c */
long ALsetUser P_((ALsession session, char *uname, ALflag_t initial_flags));

/* passwd.c */
int PWaddPasswdEntry P_((struct passwd *pwd));
int PWremovePasswdEntry P_((struct passwd *pwd));
long ALincRefCount P_((ALsession session));
void ALgetErrorContextFromFile P_((ALsession session, char *filename));
long ALaddPasswdEntry P_((ALsession session));
long ALremovePasswdEntry P_((ALsession session));
long ALupdatePasswdEntry P_((ALsession session));

/* modify.c */
int ALbeginFileUpdate P_((const char *filename, const char *lockfilename, FILE **fp, FILE **tempfp, sigset_t *mask));
int ALfinishFileUpdate P_((const char *filename, const char *lockfilename, FILE *fp, FILE *tempfp, sigset_t *mask, int ispasswd));
int ALabortFileUpdate P_((const char *filename, const char *lockfilename, FILE *fp, FILE *tempfp, sigset_t *mask));
int ALgetLine P_((FILE *fp, char **buf, int *bufsize));
int ALchangeFile P_((char *filename, char *lockfilename, char *prefix, char *line, int ispasswd));

/* group.c */
int PWaddGroups P_((struct passwd *pwd, gid_t *groups, int ngroups));
int PWremoveGroups P_((struct passwd *pwd, gid_t *groups, int ngroups));
long ALaddToGroupsFile P_((ALsession session));
long ALremoveFromGroupsFile P_((ALsession session));

/* start.c */
long ALstart P_((ALsession session, char *ttyname));
long ALend P_((ALsession session));

/* homedir.c */
int ALisRemoteDir P_((char *dir));
int ALhomedirOK P_((char *dir));
long ALgetHomedir P_((ALsession session));

/* getpwnam.c */
struct passwd *ALgetpwnam_r P_((const char *name, struct passwd *result, char *buffer, int buflen));

#undef P_
