#include	<malloc.h>
#include	<string.h>
#include	<stdio.h>
#include	<errno.h>
#include	<dlfcn.h>

/*
 * Reference a number of external data items from libfoo.so
 */
extern	int	data1, data2;
extern	char	data3[], * data4;
extern	char *	foo();
extern	char *	bar();

/*
 * Establish a number of uninitialized global variables.
 */
static	int	numb;
static	char **	addr;

static	int *	data[] = {&data1, &data2};

static	const char dynodumped[] = "dynodumped";

main(int argc, char ** argv)
{
	char *		_name;

	(void) printf("%d: 10=%d foo=%s: `%s'\n", numb, *data[0], foo(), data3);
	(void) printf("%d: 20=%d bar=%s: `%s'\n", numb, *data[1], bar(), data4);
	if (numb) {
		int	_numb;

		(void) printf("%d: ", numb);
		for (_numb = 0; _numb < numb; _numb++)
			(void) printf("%s ", addr[_numb]);
		(void) printf("\n");
	}

	if (argc == 1)
		return (0);

	if (numb == 0) {
		/*
		 * If this is the first dump of this image, allocate our addr
		 * array of pointes.
		 */
		if ((addr = (char **)malloc(sizeof (char **))) == 0) {
			(void) fprintf(stderr, "malloc failed: %s\n",
				strerror(errno));
			return (1);
		}
	} else {
		/*
		 * Otherwise, each time this image is dumped we'll add another
		 * pointer, and an associated ``dynodumped'' string.
		 */
		if ((addr = (char **)realloc((void *)addr,
		    sizeof (char **) * (numb + 1))) == 0) {
			(void) fprintf(stderr, "malloc failed: %s\n",
				strerror(errno));
			return (1);
		}
	}
	if ((addr[numb] = (char *)malloc(sizeof (dynodumped))) == 0) {
		(void) fprintf(stderr, "malloc failed: %s\n",
			strerror(errno));
		return (1);
	}

	/*
	 * Copy the ``dynodumped'' string to our new pointer reference and update
	 * the global array count.
	 */
	(void) strcpy(addr[numb++], dynodumped);

	/*
	 * Create a new name for the output image.  This consists of our
	 * present name suffixed with ``.1''.
	 */
	if ((_name = (char *)malloc(strlen(argv[0] + 3))) == 0) {
		(void) fprintf(stderr, "malloc failed: %s\n",
			strerror(errno));
		return (1);
	}
	(void) strcpy(_name, argv[0]);
	(void) strcat(_name, ".1");
	return (dynodump(_name));
}
