#!/bin/sh

#
#	This script selects an appropriate version of the On-Line Help
#	system to run, depending on the user's display type and machine
#	type.
#
#	$Source: /afs/sipb/project/sipb-athena/help/RCS/help,v $
#	$Author: yoav $
#	$Header: /afs/sipb/project/sipb-athena/help/RCS/help,v 1.1 1995/10/18 22:59:52 yoav Exp $
#

#### Configuration - Change these lines if things move.

# Configuration re. location of OLH tree
olh_topdir=/afs/athena.mit.edu/astaff/project/olh
olh_url_prefix=file://localhost${olh_topdir}
WWW_HOME=${olh_url_prefix}/index.html
olh_keywords_dir=${olh_topdir}/db
olh_keywords_url_prefix=file://localhost${olh_keywords_dir}
olh_keywords=${olh_keywords_dir}/keywords
olh_keywords_html=${olh_keywords}.html

# Configuration re. location of WWW browsers
browser_topdir=`attach -p -n infoagents`
browser_bindir=`athdir ${browser_topdir}`
browser_ascii=lynx
browser_motif=Mosaic
browser_motif_resource="Mosaic*geometry: +0+30"	# -geometry doesn't work

# Messages
msg_olc="Please call 3-4435 if you need help."
msg_topics1="The old @topic:subtopic form for accessing help topics is no
longer supported; try entering 'help "; msg_topics2="' instead."
msg_keyword1="Keyword "
msg_keyword2=" not found. Bringing up OLH Keyword list."
msg_fail1="The "; msg_fail2=" browser failed."
msg_fail_motif="Try running 'help -tty' instead."
msg_start1="Starting "; msg_start2=" World-Wide Web browser..."

#### End Configuration - No changes needed below this line.

PATH=${browser_bindir}:$PATH
export WWW_HOME

# See if X DISPLAY resource is set
case $DISPLAY in
	"")
	browser=$browser_ascii
	run_in_background=false
	;;
	*)
	browser=$browser_motif
	run_in_background=true
	;;
esac

# Parse command-line arguments
args=
lastarg=
for i in $* ; do
	case $i in
	-n* | -a* | -t*)
		browser=$browser_ascii
		run_in_background=false
		;;
	-x* | -m* )
		browser=$browser_motif
		run_in_background=true
		;;
	*)
		args="$args $lastarg"
		lastarg="$i"
		;;
	esac
done

# Choose starting page
case $lastarg in
    @*)
	# old-style arg, e.g. @zephyr:start
	topic=`echo $lastarg | tr \: \@ | awk -F@ ' { print $2 } '`
	echo "${msg_topics1}${topic}${msg_topics2}"
	exit 1
	;;
    "")
	;;
    *)
	# Extract relative URL from keyword html list
	topic=`echo $lastarg | tr A-Z a-z`
	relative_url=`awk ' $1 == "'$topic'" { print $2 }' $olh_keywords`
	case $relative_url in
	    "")
		echo "${msg_keyword1}${lastarg}${msg_keyword2}"
		starting_url=$olh_keywords_html
		;;
	    ftp:* | http:* | gopher:*)
		starting_url=$relative_url	# not really relative url
		;;
	    *)
		starting_url=${olh_keywords_url_prefix}/${relative_url}
		;;
	esac
	;;
esac

# Run program
echo ${msg_start1}${browser}${msg_start2}
failure_message="${msg_fail1}${browser}${msg_fail2}"
if [ $browser = $browser_motif ]; then
	echo "$browser_motif_resource" | xrdb -merge
	failure_message="$failure_message
$msg_fail_motif"
fi
failure_message="$failure_message
${msg_olc}"
if [ $run_in_background = true ]; then
    (($browser $args $starting_url || (echo "$failure_message")) &)
else
    $browser $args $starting_url || (echo "$failure_message")
fi

# Done
exit 0
