/*
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>
#include <sys/file.h>
#include <utmp.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/stat.h>
#ifdef NEED_SYS_FCNTL_H
#include <sys/fcntl.h>
#endif
#include <osconf.h>
#ifdef USE_UNISTD_H
#include <unistd.h>
#endif

/* solaris uses these names */
#ifdef UTMP_FILE
#define UTMPFILE UTMP_FILE
#endif
#ifdef WTMP_FILE
#define WTMPFILE WTMP_FILE
#endif

/* BSD and derivatives usually have getutent(); if not they use these names. */
#ifdef _PATH_UTMP
#define UTMPFILE _PATH_UTMP
#endif
#ifdef _PATH_WTMP
#define WTMPFILE _PATH_WTMP
#endif

#ifndef UTMPFILE
#define	UTMPFILE	"/etc/utmp"
#endif
#ifndef WTMPFILE
#define	WTMPFILE	"/usr/adm/wtmp"
#endif

#ifdef sgi
#define _AIX
#endif

#if defined(_AIX) || defined(linux) || defined(solaris20) || defined(__NetBBSD__)
#define HAVE_GETUTENT
#endif
#ifndef EMPTY
/* linux has UT_UNKNOWN but not EMPTY */
#define EMPTY UT_UNKNOWN
#endif

void
login(ut)
	struct utmp *ut;
{
	register int fd;
	struct utmp utmp;
	int tty;
	FILE *fp;

#ifdef linux
	/*
	 *  the existing code was always overwriting the same utmp entry.
	 *  it's probably possible to get it to work using sysv
	 *  utmp functions, but I don't know enough about how them.
	 *  so i wrote this instead.  --svalente
	 */
	/*
	 *  getty_ps execs login from the process that initialized
	 *  the utmp entry.  therefore, we look for the current
	 *  pid, not the ppid.
	 */
	ut->ut_pid = getpid ();
	ut->ut_type = USER_PROCESS;

	if ((fp = fopen (UTMPFILE, "r+")) != NULL) {
	  while (fread ((char *) &utmp, sizeof (utmp), 1, fp) == 1)
	    if (utmp.ut_pid == ut->ut_pid) {
	      strncpy (ut->ut_id, utmp.ut_id, sizeof (utmp.ut_id));
	      fseek (fp, (long)-sizeof (utmp), SEEK_CUR);
	      break;
	    }
	  fwrite ((char *) ut, sizeof (utmp), 1, fp);
	  fclose (fp);
	}
#else /* ! linux */
#ifdef HAVE_GETUTENT
	if (!ut->ut_pid)
		ut->ut_pid = getppid();
	ut->ut_type = USER_PROCESS;
	(void) strncpy(ut->ut_id, ut->ut_line, sizeof(ut->ut_id));

	(void) setutent();
	(void) memset((char *)&utmp, 0, sizeof(utmp));
	(void) strncpy(utmp.ut_id, ut->ut_id, sizeof(utmp.ut_id));
	utmp.ut_type = DEAD_PROCESS;
	(void) getutid(&utmp);

	(void) pututline(ut);
	(void) endutent();
#else /* ! HAVE_GETUTENT */
	tty = ttyslot();
	if (tty > 0 && (fd = open(UTMPFILE, O_WRONLY, 0)) >= 0) {
		(void)lseek(fd, (long)(tty * sizeof(struct utmp)), SEEK_SET);
		(void)write(fd, (char *)ut, sizeof(struct utmp));
		(void)close(fd);
	}
#endif
#endif /* linux */

	if ((fd = open(WTMPFILE, O_WRONLY|O_APPEND, 0)) >= 0) {
		(void)write(fd, (char *)ut, sizeof(struct utmp));
		(void)close(fd);
	}
}

logout(line)
	register char *line;
{
	register FILE *fp;
	struct utmp ut;
	int rval;

	if (!(fp = fopen(UTMPFILE, "r+")))
		return(0);
	rval = 1;
	while (fread((char *)&ut, sizeof(struct utmp), 1, fp) == 1) {
		if (!ut.ut_name[0] ||
		    strncmp(ut.ut_line, line, sizeof(ut.ut_line)))
			continue;
		(void)memset(ut.ut_name, 0, sizeof(ut.ut_name));
#ifndef NOUTHOST
		(void)memset(ut.ut_host, 0, sizeof(ut.ut_host));
#endif
		(void)time(&ut.ut_time);
#ifdef HAVE_GETUTENT
		(void)memset(ut.ut_id, 0, sizeof(ut.ut_id));
		ut.ut_pid = 0;
#ifndef linux
		ut.ut_exit.e_exit = 0;
#endif
		ut.ut_type = EMPTY;
#endif
		(void)fseek(fp, (long)-sizeof(struct utmp), SEEK_CUR);
		(void)fwrite((char *)&ut, sizeof(struct utmp), 1, fp);
		(void)fseek(fp, (long)0, SEEK_CUR);
		rval = 0;
	}
	(void)fclose(fp);
	return(rval);
}

logwtmp(line, name, host)
	char *line, *name, *host;
{
	struct utmp ut;
	struct stat buf;
	int fd;

	if ((fd = open(WTMPFILE, O_WRONLY|O_APPEND, 0)) < 0)
		return;
	if (!fstat(fd, &buf)) {
		(void)memset((char *)&ut, 0, sizeof(ut));
		(void)strncpy(ut.ut_line, line, sizeof(ut.ut_line));
		(void)strncpy(ut.ut_name, name, sizeof(ut.ut_name));
#ifndef NOUTHOST
		(void)strncpy(ut.ut_host, host, sizeof(ut.ut_host));
#endif
		(void)time(&ut.ut_time);
#ifdef HAVE_GETUTENT
		if (*name) {
			if (!ut.ut_pid)
				ut.ut_pid = getpid();
			ut.ut_type = USER_PROCESS;
		} else {
			ut.ut_type = EMPTY;
		}
#endif
		if (write(fd, (char *)&ut, sizeof(struct utmp)) !=
		    sizeof(struct utmp))
			(void)ftruncate(fd, buf.st_size);
	}
	(void)close(fd);
}
