/*
 * $Source: /local/cvsfiles/kerberos/src/lib/des/noop.c,v $
 * $Author: eichin $
 *
 * Copyright 1985, 1986, 1987, 1988 by the Massachusetts Institute
 * of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 *
 * These routines perform encryption and decryption using the DES
 * private key algorithm, or else a subset of it-- fewer inner loops.
 * (AUTH_DES_ITER defaults to 16, may be less.)
 *
 * Under U.S. law, this software may not be exported outside the US
 * without license from the U.S. Commerce department.
 *
 * The key schedule is passed as an arg, as well as the cleartext or
 * ciphertext.
 *
 *  All registers labeled imply Vax using the Ultrix or 4.2bsd compiler.
 *
 *	NOTE:  bit and byte numbering:
 *			DES algorithm is defined in terms of bits of L
 *			followed by bits of R:
 *
 *			bit 0  ==> lsb of L
 *			bit 63 ==> msb of R
 *
 * Always work in register pairs, FROM L1,R1 TO L2,R2 to make
 * bookeeping easier.
 *
 * spm	8/85	MIT project athena
 */

#ifndef	lint
static char rcsid_noop_c[] =
"$Header: /local/cvsfiles/kerberos/src/lib/des/noop.c,v 1.1.1.2 1991/12/03 18:51:03 eichin Exp $";
#endif	lint

#include <mit-copyright.h>
#include <stdio.h>

#include <des.h>

#ifdef DEBUG
#define DBG_PRINT(s)	if (debug) \
    des_debug_print(s,i,L1&0xffff,(L1>>16)&0xffff, \
		R1&0xffff,(R1>>16)&0xffff)
#else
#define DBG_PRINT(s)
#endif

extern	int	des_debug;

int
des_ecb_encrypt(clear, cipher, schedule, encrypt)
    unsigned long *clear;
    unsigned long *cipher;
    int encrypt;		/* 0 ==> decrypt, else encrypt */
    register des_key_schedule schedule; /* r11 */
{
    /* a debugging version that only copies input to output */
    *cipher++ = *clear++;
    *cipher = *clear;

    return 0;
}
